/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class SpreadSubsample
extends Filter
implements SupervisedFilter,
OptionHandler {
    private int m_RandomSeed = 1;
    private int m_MaxCount;
    private boolean m_FirstBatchDone = false;
    private double m_DistributionSpread = 0.0;
    private boolean m_AdjustWeights = false;

    public String globalInfo() {
        return "Produces a random subsample of a dataset. The original dataset must fit entirely in memory. This filter allows you to specify the maximum \"spread\" between the rarest and most common class. For example, you may specify that there be at most a 2:1 difference in class frequencies. When used in batch mode, subsequent batches are NOT resampled.";
    }

    public String adjustWeightsTipText() {
        return "Wether instance weights will be adjusted to maintain total weight per class.";
    }

    public boolean getAdjustWeights() {
        return this.m_AdjustWeights;
    }

    public void setAdjustWeights(boolean bl) {
        this.m_AdjustWeights = bl;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tSpecify the random number seed (default 1)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tThe maximum class distribution spread.\n\t0 = no maximum spread, 1 = uniform distribution, 10 = allow at most\n\ta 10:1 ratio between the classes (default 0)", "M", 1, "-M <num>"));
        vector.addElement(new Option("\tAdjust weights so that total weight per class is maintained.\n\tIndividual instance weighting is not preserved. (default no\n\tweights adjustment", "W", 0, "-W"));
        vector.addElement(new Option("\tThe maximum count for any class value (default 0 = unlimited).\n", "X", 0, "-X <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setRandomSeed(Integer.parseInt(string));
        } else {
            this.setRandomSeed(1);
        }
        String string2 = Utils.getOption('M', stringArray);
        if (string2.length() != 0) {
            this.setDistributionSpread(Double.valueOf(string2));
        } else {
            this.setDistributionSpread(0.0);
        }
        String string3 = Utils.getOption('X', stringArray);
        if (string3.length() != 0) {
            this.setMaxCount(Double.valueOf(string3));
        } else {
            this.setMaxCount(0.0);
        }
        this.setAdjustWeights(Utils.getFlag('W', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[7];
        int n = 0;
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getDistributionSpread();
        stringArray[n++] = "-X";
        stringArray[n++] = "" + this.getMaxCount();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getRandomSeed();
        if (this.getAdjustWeights()) {
            stringArray[n++] = "-W";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String distributionSpreadTipText() {
        return "The maximum class distribution spread. (0 = no maximum spread, 1 = uniform distribution, 10 = allow at most a 10:1 ratio between the classes).";
    }

    public void setDistributionSpread(double d) {
        this.m_DistributionSpread = d;
    }

    public double getDistributionSpread() {
        return this.m_DistributionSpread;
    }

    public String maxCountTipText() {
        return "The maximum count for any class value (0 = unlimited).";
    }

    public void setMaxCount(double d) {
        this.m_MaxCount = (int)d;
    }

    public double getMaxCount() {
        return this.m_MaxCount;
    }

    public String randomSeedTipText() {
        return "Sets the random number seed for subsampling.";
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int n) {
        this.m_RandomSeed = n;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException("The class attribute must be nominal.");
        }
        this.setOutputFormat(instances);
        this.m_FirstBatchDone = false;
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_FirstBatchDone) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.m_FirstBatchDone) {
            this.createSubsample();
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    private void createSubsample() {
        int n;
        int n2 = this.getInputFormat().classIndex();
        this.getInputFormat().sort(n2);
        int[] nArray = this.getClassIndices();
        int[] nArray2 = new int[this.getInputFormat().numClasses()];
        double[] dArray = new double[this.getInputFormat().numClasses()];
        int n3 = -1;
        for (n = 0; n < this.getInputFormat().numInstances(); ++n) {
            Instance instance = this.getInputFormat().instance(n);
            if (instance.classIsMissing()) continue;
            int n4 = (int)instance.classValue();
            nArray2[n4] = nArray2[n4] + 1;
            int n5 = (int)instance.classValue();
            dArray[n5] = dArray[n5] + instance.weight();
        }
        for (n = 0; n < nArray2.length; ++n) {
            if (nArray2[n] <= 0) continue;
            dArray[n] = dArray[n] / (double)nArray2[n];
        }
        for (n = 0; n < nArray2.length; ++n) {
            if (n3 < 0 && nArray2[n] > 0) {
                n3 = nArray2[n];
                continue;
            }
            if (nArray2[n] >= n3 || nArray2[n] <= 0) continue;
            n3 = nArray2[n];
        }
        if (n3 < 0) {
            System.err.println("SpreadSubsample: *warning* none of the classes have any values in them.");
            return;
        }
        int[] nArray3 = new int[this.getInputFormat().numClasses()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray3[i] = (int)Math.abs(Math.min((double)nArray2[i], (double)n3 * this.m_DistributionSpread));
            if (this.m_DistributionSpread == 0.0) {
                nArray3[i] = nArray2[i];
            }
            if (this.m_MaxCount <= 0) continue;
            nArray3[i] = Math.min(nArray3[i], this.m_MaxCount);
        }
        Random random = new Random(this.m_RandomSeed);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < nArray3.length; ++i) {
            double d = 1.0;
            if (this.m_AdjustWeights && nArray3[i] > 0) {
                d = dArray[i] * (double)nArray2[i] / (double)nArray3[i];
            }
            for (int j = 0; j < nArray3[i]; ++j) {
                boolean bl = false;
                do {
                    int n6 = nArray[i] + Math.abs(random.nextInt()) % (nArray[i + 1] - nArray[i]);
                    if (hashtable.get("" + n6) != null) continue;
                    hashtable.put("" + n6, "");
                    bl = true;
                    if (n6 < 0) continue;
                    Instance instance = (Instance)this.getInputFormat().instance(n6).copy();
                    if (this.m_AdjustWeights) {
                        instance.setWeight(d);
                    }
                    this.push(instance);
                } while (!bl);
            }
        }
    }

    private int[] getClassIndices() {
        int n;
        int[] nArray = new int[this.getInputFormat().numClasses() + 1];
        int n2 = 0;
        nArray[n2] = 0;
        for (n = 0; n < this.getInputFormat().numInstances(); ++n) {
            int n3;
            Instance instance = this.getInputFormat().instance(n);
            if (instance.classIsMissing()) {
                for (n3 = n2 + 1; n3 < nArray.length; ++n3) {
                    nArray[n3] = n;
                }
                break;
            }
            if (instance.classValue() == (double)n2) continue;
            n3 = n2 + 1;
            while ((double)n3 <= instance.classValue()) {
                nArray[n3] = n;
                ++n3;
            }
            n2 = (int)instance.classValue();
        }
        if (n2 <= this.getInputFormat().numClasses()) {
            for (n = n2 + 1; n < nArray.length; ++n) {
                nArray[n] = this.getInputFormat().numInstances();
            }
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new SpreadSubsample(), stringArray);
            } else {
                Filter.filterFile(new SpreadSubsample(), stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

