/*
 * Decompiled with CFR 0.152.
 */
package eduni.distributions;

import eduni.distributions.DiscreteGenerator;
import eduni.distributions.Generator;
import eduni.distributions.ParameterException;

public class Binomial
extends Generator
implements DiscreteGenerator {
    private double prob;
    private int trials;

    public Binomial(double d, int n) {
        this.set(d, n);
    }

    public Binomial(double d, int n, long l) {
        super(l);
        this.set(d, n);
    }

    private void set(double d, int n) {
        if (d <= 0.0) {
            throw new ParameterException("Binomial: The probability of success must be between 0 and 1.");
        }
        if (n <= 0) {
            throw new ParameterException("Binomial: The number of trials must be a positive integer.");
        }
        this.prob = d;
        this.trials = n;
    }

    public long sample() {
        return this.distrib.binomial(this.prob, this.trials);
    }
}

