/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ru.RussianCharsets;

public final class RussianLowerCaseFilter
extends TokenFilter {
    char[] charset;

    public RussianLowerCaseFilter(TokenStream in, char[] charset) {
        super(in);
        this.charset = charset;
    }

    public final Token next() throws IOException {
        Token t = this.input.next();
        if (t == null) {
            return null;
        }
        String txt = t.termText();
        char[] chArray = txt.toCharArray();
        int i = 0;
        while (i < chArray.length) {
            chArray[i] = RussianCharsets.toLowerCase(chArray[i], this.charset);
            ++i;
        }
        String newTxt = new String(chArray);
        Token newToken = new Token(newTxt, t.startOffset(), t.endOffset());
        return newToken;
    }
}

