/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

public class WildcardTermEnum
extends FilteredTermEnum {
    Term searchTerm;
    String field = "";
    String text = "";
    String pre = "";
    int preLen = 0;
    boolean fieldMatch = false;
    boolean endEnum = false;
    public static final char WILDCARD_STRING = '*';
    public static final char WILDCARD_CHAR = '?';

    public WildcardTermEnum(IndexReader reader, Term term) throws IOException {
        super(reader, term);
        this.searchTerm = term;
        this.field = this.searchTerm.field();
        this.text = this.searchTerm.text();
        int sidx = this.text.indexOf(42);
        int cidx = this.text.indexOf(63);
        int idx = sidx;
        if (idx == -1) {
            idx = cidx;
        } else if (cidx >= 0) {
            idx = Math.min(idx, cidx);
        }
        this.pre = this.searchTerm.text().substring(0, idx);
        this.preLen = this.pre.length();
        this.text = this.text.substring(this.preLen);
        this.setEnum(reader.terms(new Term(this.searchTerm.field(), this.pre)));
    }

    protected final boolean termCompare(Term term) {
        String searchText;
        if (this.field == term.field() && (searchText = term.text()).startsWith(this.pre)) {
            return WildcardTermEnum.wildcardEquals(this.text, 0, searchText, this.preLen);
        }
        this.endEnum = true;
        return false;
    }

    public final float difference() {
        return 1.0f;
    }

    public final boolean endEnum() {
        return this.endEnum;
    }

    public static final boolean wildcardEquals(String pattern, int patternIdx, String string, int stringIdx) {
        int p = patternIdx;
        int s = stringIdx;
        while (true) {
            boolean pEnd;
            boolean sEnd = s >= string.length();
            boolean bl = pEnd = p >= pattern.length();
            if (sEnd) {
                boolean justWildcardsLeft = true;
                int wildcardSearchPos = p;
                while (wildcardSearchPos < pattern.length() && justWildcardsLeft) {
                    char wildchar = pattern.charAt(wildcardSearchPos);
                    if (wildchar != '?' && wildchar != '*') {
                        justWildcardsLeft = false;
                        continue;
                    }
                    ++wildcardSearchPos;
                }
                if (justWildcardsLeft) {
                    return true;
                }
            }
            if (sEnd || pEnd) break;
            if (pattern.charAt(p) != '?') {
                if (pattern.charAt(p) == '*') {
                    ++p;
                    int i = string.length();
                    while (i >= s) {
                        if (WildcardTermEnum.wildcardEquals(pattern, p, string, i)) {
                            return true;
                        }
                        --i;
                    }
                    break;
                }
                if (pattern.charAt(p) != string.charAt(s)) break;
            }
            ++p;
            ++s;
        }
        return false;
    }

    public void close() throws IOException {
        super.close();
        this.searchTerm = null;
        this.field = null;
        this.text = null;
    }
}

