/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;

public final class BitVector {
    private byte[] bits;
    private int size;
    private int count = -1;
    private static final byte[] BYTE_COUNTS = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};

    public BitVector(int n) {
        this.size = n;
        this.bits = new byte[(this.size >> 3) + 1];
    }

    public final void set(int bit) {
        int n = bit >> 3;
        this.bits[n] = (byte)(this.bits[n] | 1 << (bit & 7));
        this.count = -1;
    }

    public final void clear(int bit) {
        int n = bit >> 3;
        this.bits[n] = (byte)(this.bits[n] & ~(1 << (bit & 7)));
        this.count = -1;
    }

    public final boolean get(int bit) {
        return (this.bits[bit >> 3] & 1 << (bit & 7)) != 0;
    }

    public final int size() {
        return this.size;
    }

    public final int count() {
        if (this.count == -1) {
            int c = 0;
            int end = this.bits.length;
            int i = 0;
            while (i < end) {
                c += BYTE_COUNTS[this.bits[i] & 0xFF];
                ++i;
            }
            this.count = c;
        }
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Directory d, String name) throws IOException {
        OutputStream output = d.createFile(name);
        try {
            output.writeInt(this.size());
            output.writeInt(this.count());
            output.writeBytes(this.bits, this.bits.length);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            output.close();
            throw throwable;
        }
        output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitVector(Directory d, String name) throws IOException {
        InputStream input = d.openFile(name);
        try {
            this.size = input.readInt();
            this.count = input.readInt();
            this.bits = new byte[(this.size >> 3) + 1];
            input.readBytes(this.bits, 0, this.bits.length);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            input.close();
            throw throwable;
        }
        input.close();
    }
}

