/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.tokens.SimpleTokenizer;
import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractStatisticalTokenDistance
extends AbstractStringDistance {
    protected Tokenizer tokenizer;
    protected Map documentFrequency = new HashMap();
    private static final Integer ONE = new Integer(1);
    private static final Integer TWO = new Integer(2);
    private static final Integer THREE = new Integer(3);
    protected int collectionSize = 0;
    protected int totalTokenCount = 0;

    public AbstractStatisticalTokenDistance(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public AbstractStatisticalTokenDistance() {
        this(SimpleTokenizer.DEFAULT_TOKENIZER);
    }

    public void accumulateStatistics(Iterator i) {
        HashSet<Token> seenTokens = new HashSet<Token>();
        while (i.hasNext()) {
            StringWrapper s = (StringWrapper)i.next();
            Token[] toks = this.tokenizer.tokenize(s.unwrap());
            seenTokens.clear();
            for (int j = 0; j < toks.length; ++j) {
                ++this.totalTokenCount;
                if (seenTokens.contains(toks[j])) continue;
                seenTokens.add(toks[j]);
                Integer df = (Integer)this.documentFrequency.get(toks[j]);
                if (df == null) {
                    this.documentFrequency.put(toks[j], ONE);
                    continue;
                }
                if (df == ONE) {
                    this.documentFrequency.put(toks[j], TWO);
                    continue;
                }
                if (df == TWO) {
                    this.documentFrequency.put(toks[j], THREE);
                    continue;
                }
                this.documentFrequency.put(toks[j], new Integer(df + 1));
            }
            ++this.collectionSize;
        }
    }

    public int getDocumentFrequency(Token tok) {
        Integer freqInteger = (Integer)this.documentFrequency.get(tok);
        if (freqInteger == null) {
            return 0;
        }
        return freqInteger;
    }
}

