/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.tokens.Token;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

class BagOfTokens
extends StringWrapper {
    private Map weightMap = new TreeMap();
    private double totalWeight = 0.0;

    BagOfTokens(String s, Token[] toks) {
        super(s);
        for (int i = 0; i < toks.length; ++i) {
            this.weightMap.put(toks[i], new Double(this.getWeight(toks[i]) + 1.0));
        }
        this.totalWeight = toks.length;
    }

    Iterator tokenIterator() {
        return this.weightMap.keySet().iterator();
    }

    boolean contains(Token tok) {
        return this.weightMap.get(tok) != null;
    }

    double getWeight(Token tok) {
        Double f = (Double)this.weightMap.get(tok);
        return f == null ? 0.0 : f;
    }

    void setWeight(Token tok, double d) {
        Double oldWeight = (Double)this.weightMap.get(tok);
        this.totalWeight += oldWeight == null ? d : d - oldWeight;
        this.weightMap.put(tok, new Double(d));
    }

    int size() {
        return this.weightMap.keySet().size();
    }

    double getTotalWeight() {
        return this.totalWeight;
    }
}

