/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference.gbp;

import cc.mallet.grmm.inference.gbp.Region;
import cc.mallet.grmm.inference.gbp.RegionGraph;
import cc.mallet.grmm.inference.gbp.RegionGraphGenerator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.UndirectedGrid;
import cc.mallet.grmm.types.Variable;
import cc.mallet.util.ArrayUtils;
import java.util.Iterator;

public class Kikuchi4SquareRegionGenerator
implements RegionGraphGenerator {
    public RegionGraph constructRegionGraph(FactorGraph mdl) {
        if (mdl instanceof UndirectedGrid) {
            RegionGraph rg = new RegionGraph();
            UndirectedGrid grid = (UndirectedGrid)mdl;
            for (int x = 0; x < grid.getWidth() - 1; ++x) {
                for (int y = 0; y < grid.getHeight() - 1; ++y) {
                    int i;
                    Variable[] vars = new Variable[]{grid.get(x, y), grid.get(x + 1, y), grid.get(x + 1, y + 1), grid.get(x, y + 1)};
                    Factor[] edges = new Factor[]{mdl.factorOf(vars[0], vars[1]), mdl.factorOf(vars[1], vars[2]), mdl.factorOf(vars[2], vars[3]), mdl.factorOf(vars[0], vars[3])};
                    Region fourSquare = new Region(vars, edges);
                    for (i = 0; i < 4; ++i) {
                        Variable var = vars[i];
                        Factor ptl = mdl.factorOf(var);
                        if (ptl == null) continue;
                        fourSquare.factors.add(ptl);
                    }
                    for (i = 0; i < 4; ++i) {
                        Factor edgePtl = edges[i];
                        Region edgeRgn = rg.findRegion(edgePtl, true);
                        rg.add(fourSquare, edgeRgn);
                        Variable v1 = (Variable)edgeRgn.vars.get(0);
                        Region nodeRgn = this.createVarRegion(rg, mdl, v1);
                        edgeRgn.factors.addAll(nodeRgn.factors);
                        rg.add(edgeRgn, nodeRgn);
                        Variable v2 = (Variable)edgeRgn.vars.get(1);
                        nodeRgn = this.createVarRegion(rg, mdl, v2);
                        edgeRgn.factors.addAll(nodeRgn.factors);
                        rg.add(edgeRgn, nodeRgn);
                    }
                }
            }
            rg.computeInferenceCaches();
            return rg;
        }
        throw new UnsupportedOperationException("Kikuchi4SquareRegionGenerator requires that you use UndirectedGrid.");
    }

    private Region createVarRegion(RegionGraph rg, FactorGraph mdl, Variable v1) {
        Factor ptl = mdl.factorOf(v1);
        if (ptl == null) {
            return rg.findRegion(v1, true);
        }
        return rg.findRegion(ptl, true);
    }

    private void checkAllSingles(RegionGraph rg, Region[] nodeRegions) {
        Iterator it = rg.iterator();
        while (it.hasNext()) {
            Region region = (Region)it.next();
            if (region.vars.size() != 1 || ArrayUtils.indexOf(nodeRegions, region) >= 0) continue;
            throw new IllegalStateException("huh?");
        }
    }

    private void checkTooManyDoubles(RegionGraph rg, FactorGraph mdl) {
        int nv = mdl.factors().size();
        int doubles = 0;
        Iterator it = rg.iterator();
        while (it.hasNext()) {
            Region region = (Region)it.next();
            if (region.vars.size() != 2) continue;
            ++doubles;
        }
        if (doubles > nv) {
            throw new IllegalStateException("huh? ");
        }
    }
}

