/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.types.Instance;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvIterator
implements Iterator<Instance> {
    LineNumberReader reader;
    Pattern lineRegex;
    int uriGroup;
    int targetGroup;
    int dataGroup;
    String currentLine;

    public CsvIterator(Reader input, Pattern lineRegex, int dataGroup, int targetGroup, int uriGroup) {
        this.reader = new LineNumberReader(input);
        this.lineRegex = lineRegex;
        this.targetGroup = targetGroup;
        this.dataGroup = dataGroup;
        this.uriGroup = uriGroup;
        if (dataGroup <= 0) {
            throw new IllegalStateException("You must extract a data field.");
        }
        try {
            this.currentLine = this.reader.readLine();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    public CsvIterator(Reader input, String lineRegex, int dataGroup, int targetGroup, int uriGroup) {
        this(input, Pattern.compile(lineRegex), dataGroup, targetGroup, uriGroup);
    }

    public CsvIterator(String filename, String lineRegex, int dataGroup, int targetGroup, int uriGroup) throws FileNotFoundException {
        this((Reader)new FileReader(new File(filename)), Pattern.compile(lineRegex), dataGroup, targetGroup, uriGroup);
    }

    @Override
    public Instance next() {
        String uriStr = null;
        String data = null;
        String target = null;
        Matcher matcher = this.lineRegex.matcher(this.currentLine);
        if (matcher.find()) {
            if (this.uriGroup > 0) {
                uriStr = matcher.group(this.uriGroup);
            }
            if (this.targetGroup > 0) {
                target = matcher.group(this.targetGroup);
            }
            if (this.dataGroup > 0) {
                data = matcher.group(this.dataGroup);
            }
        } else {
            throw new IllegalStateException("Line #" + this.reader.getLineNumber() + " does not match regex");
        }
        String uri = uriStr == null ? "csvline:" + this.reader.getLineNumber() : uriStr;
        assert (data != null);
        Instance carrier = new Instance(data, target, uri, null);
        try {
            this.currentLine = this.reader.readLine();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
        return carrier;
    }

    @Override
    public boolean hasNext() {
        return this.currentLine != null;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }
}

