/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex;

import edu.umass.cs.dex.graph.PeopleGraph;
import edu.umass.cs.dex.types.PeopleManager;
import edu.umass.cs.dex.web.LicenseKeyManager;
import edu.umass.cs.mallet.base.util.CommandOption;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.File;
import java.util.logging.Logger;

public class DEX {
    private static Logger logger = MalletLogger.getLogger(DEX.class.getName());
    private static final String input = "input";
    private static final String output = "output2";
    static CommandOption.File inputDirOption = new CommandOption.File(DEX.class, "input-dir", "FILE", false, null, "input directory containing emails", null);
    static CommandOption.File inputFileOption = new CommandOption.File(DEX.class, "input-file", "FILE", false, null, "input file containing lists of names/emails, one per line, eg: jsmith@nowhere.com Jon Smith", null);
    static CommandOption.File outputDirOption = new CommandOption.File(DEX.class, "output-dir", "FILE", true, new File("output2"), "output directory to place discovered web pages", null);
    static CommandOption.File resourceDirOption = new CommandOption.File(DEX.class, "resource-dir", "FILE", true, new File("resources"), "resource directory (stores stop list, crf, googleKey)", null);
    static CommandOption.String keywordDirOption = new CommandOption.String(DEX.class, "keyword-dir", "STRING", true, new String("keywords"), "output directory to place keywords extracted for each person (relative to --output-dir)", null);
    static CommandOption.String csvOutputOption = new CommandOption.String(DEX.class, "csv-output", "STRING", true, new String("output.csv"), "csv output file (relative to --output-dir)", null);
    static CommandOption.String htmlOutputOption = new CommandOption.String(DEX.class, "html-output", "STRING", true, new String("output.html"), "html output file (relative to --output-dir)", null);
    static CommandOption.String txtOutputOption = new CommandOption.String(DEX.class, "txt-output", "STRING", true, new String("output.txt"), "text output file (relative to --output-dir)", null);
    static CommandOption.String vcfOutputOption = new CommandOption.String(DEX.class, "vcf-output", "STRING", true, new String("output.vcf"), "VCF (vCard format) output file (relative to --output-dir)", null);
    static CommandOption.String zoomOutputOption = new CommandOption.String(DEX.class, "zoom-output", "STRING", true, new String("zoom.dat"), "name of Zoom graph file to print topology of network (relative to --output-dir)", null);
    static CommandOption.String stopListOption = new CommandOption.String(DEX.class, "stop-list", "STRING", true, new String("stop"), "stop list file for keywords (relative to --resource-dir)", null);
    static CommandOption.String readPeopleOption = new CommandOption.String(DEX.class, "read-people", "STRING", true, null, "serialized file to load People from (relative to --output-dir)", null);
    static CommandOption.String writePeopleOption = new CommandOption.String(DEX.class, "write-people", "STRING", true, new String("people.obj"), "serialized file to save People to (relative to --output-dir)", null);
    static CommandOption.String writeGraphOption = new CommandOption.String(DEX.class, "write-graph", "FILE", true, new String("graph.obj"), "serialized file to save clustered network to (relative to --output-dir", null);
    static CommandOption.String userNameOption = new CommandOption.String(DEX.class, "user-name", "FILE", true, null, "name of user whose email this is", null);
    static CommandOption.String crfFileOption = new CommandOption.String(DEX.class, "crf-file", "STRING", true, new String("record-extractor-crf.obj"), "CRF object file to perform contact record extraction (relative to --resource-dir)", null);
    static CommandOption.String googleKeyFileOption = new CommandOption.String(DEX.class, "google-key-file", "STRING", true, new String("keys"), "file containg key for Google API (relative to --resource-dir)", null);
    static CommandOption.Boolean confidencePredictionOption = new CommandOption.Boolean(DEX.class, "confidence-prediction", "true|false", false, false, "predict confidence of each extracted field?", null);
    static CommandOption.Integer numberHopsOption = new CommandOption.Integer(DEX.class, "number-hops", "INTEGER", true, 1, "The number of outlink hops to explore from the initial set of people.", null);
    static CommandOption.Integer maxPagesOption = new CommandOption.Integer(DEX.class, "max-pages", "INTEGER", true, 15, "The maximum number of web pages to download for each person.", null);
    static final CommandOption.List commandOptions = new CommandOption.List("DEX: Automated Rolodex Construction from Email.", new CommandOption[]{inputDirOption, inputFileOption, outputDirOption, resourceDirOption, userNameOption, confidencePredictionOption, crfFileOption, googleKeyFileOption, csvOutputOption, htmlOutputOption, zoomOutputOption, txtOutputOption, vcfOutputOption, keywordDirOption, stopListOption, numberHopsOption, maxPagesOption, readPeopleOption, writePeopleOption, writeGraphOption});

    public static void main(String[] args) {
        commandOptions.process(args);
        logger.info("---------------------");
        logger.info("OPTIONS:");
        commandOptions.logOptions(logger);
        logger.info("---------------------");
        DEX.makeDir(DEX.outputDirOption.value);
        DEX.validateOptions();
        String licenseFileAccessCode = "allowed";
        LicenseKeyManager.initialize(new File(DEX.resourceDirOption.value, DEX.googleKeyFileOption.value), licenseFileAccessCode);
        LicenseKeyManager.getInstance().setUsersLicenseFileAccessCode(licenseFileAccessCode);
        PeopleManager pm = new PeopleManager(DEX.inputDirOption.value, DEX.inputFileOption.value, DEX.outputDirOption.value, new File(DEX.resourceDirOption.value, DEX.stopListOption.value), DEX.userNameOption.value, DEX.readPeopleOption.value == null ? null : new File(DEX.resourceDirOption.value, DEX.readPeopleOption.value), new File(DEX.outputDirOption.value, DEX.vcfOutputOption.value), new File(DEX.outputDirOption.value, DEX.htmlOutputOption.value), new File(DEX.outputDirOption.value, DEX.keywordDirOption.value), new File(DEX.outputDirOption.value, DEX.writePeopleOption.value), DEX.maxPagesOption.value);
        pm.writeTXT(new File(DEX.outputDirOption.value, DEX.txtOutputOption.value));
        pm.expandSocialNetwork(DEX.numberHopsOption.value, new File(DEX.resourceDirOption.value, DEX.crfFileOption.value));
        pm.setKeywords();
        if (DEX.writePeopleOption.value != null) {
            pm.writePeople(new File(DEX.outputDirOption.value, DEX.writePeopleOption.value));
        }
        pm.writeTXT(new File(DEX.outputDirOption.value, DEX.txtOutputOption.value));
        pm.writeHTML(new File(DEX.outputDirOption.value, DEX.htmlOutputOption.value));
        pm.writeVCF(new File(DEX.outputDirOption.value, DEX.vcfOutputOption.value));
        PeopleGraph pg = new PeopleGraph(pm.getPeople());
        pg.printAllStatistics(new File(DEX.outputDirOption.value, DEX.zoomOutputOption.value));
        pg.writeGraph(new File(DEX.outputDirOption.value, DEX.writeGraphOption.value));
    }

    public static void makeDir(File dir) {
        try {
            if (!dir.exists()) {
                dir.mkdir();
            }
        }
        catch (SecurityException e) {
            System.out.println("No permission to make directory " + dir);
        }
    }

    public static void validateOptions() {
        String err = "";
        if (!DEX.resourceDirOption.value.exists()) {
            err = err + "\nCannot locate --resource-dir: " + DEX.resourceDirOption.value;
        } else {
            File stop = new File(DEX.resourceDirOption.value, DEX.stopListOption.value);
            File crf = new File(DEX.resourceDirOption.value, DEX.crfFileOption.value);
            File key = new File(DEX.resourceDirOption.value, DEX.googleKeyFileOption.value);
            if (!stop.exists()) {
                err = err + "\nCannot locate --stop-list: " + stop.getAbsolutePath();
            }
            if (!crf.exists()) {
                err = err + "\nCannot locate --crf-file: " + crf.getAbsolutePath();
            }
            if (!key.exists()) {
                err = err + "\nCannot locate --google-key-file: " + key.getAbsolutePath();
            }
        }
        if (DEX.inputDirOption.value != null && !DEX.inputDirOption.value.exists() && DEX.inputFileOption.value != null && !DEX.inputFileOption.value.exists()) {
            err = err + "\nCannot locate --input-dir " + DEX.inputDirOption.value + " or --input-file " + DEX.inputFileOption.value;
        }
        if (!err.equals("")) {
            System.err.println(err);
            System.exit(-1);
        }
    }
}

