/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.types;

import edu.umass.cs.dex.types.CountedString;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContactRecord
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(ContactRecord.class.getName());
    private HashMap fields = new HashMap();
    private ArrayList names = new ArrayList();
    private static final Pattern PHONE = Pattern.compile(".*[Nn][Uu][Mm][Bb][Ee][Rr].*");
    private static final Pattern EMAIL = Pattern.compile("[Ee][Mm][Aa][Ii][Ll]");
    private static final Pattern URL = Pattern.compile(".*[Uu][Rr][Ll]");
    private static final Pattern LASTNAME = Pattern.compile("[Ll][Aa][Ss][Tt][Nn][Aa][Mm][Ee]");
    private static final Pattern F_PHONE = Pattern.compile("[x\u0000-9\\(\\)\\[\\]\\-\\/\\.]+");
    private static final Pattern F_EMAIL = Pattern.compile(".*@.*");
    private static final Pattern F_URL = Pattern.compile(".*www\\.|http.*");
    private static final Pattern F_LASTNAME = Pattern.compile(".*\\p{Alpha}\\p{Alpha}.*");
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public void freeNames() {
        this.names = null;
        this.names = new ArrayList();
    }

    public void setNames(ArrayList peeps) {
        this.names = peeps;
    }

    public ArrayList getNames() {
        return this.names;
    }

    public void addName(CountedString n) {
        this.names.add(n);
    }

    public void addNames(ArrayList a) {
        this.names.addAll(a);
    }

    public void addAll(String key, ArrayList values) {
        Vector<String> v = (Vector<String>)this.fields.get(key);
        if (v == null) {
            v = new Vector<String>();
        }
        for (int i = 0; i < values.size(); ++i) {
            String w = (String)values.get(i);
            if (!this.filter(key, w = this.removeEndline(w))) continue;
            v.add(w);
        }
        if (v.size() > 0) {
            this.fields.put(key, v);
        }
    }

    public void setFieldValue(String key, String value) {
        Vector<String> v = (Vector<String>)this.fields.get(key);
        if (v == null) {
            v = new Vector<String>();
        }
        if (this.filter(key, value = this.removeEndline(value))) {
            v.add(value);
            this.fields.put(key, v);
        }
    }

    public int size() {
        return this.numberFields();
    }

    public boolean hasField(String key) {
        return (Vector)this.fields.get(key) != null;
    }

    public String getFirstValue(String key) {
        if (this.hasField(key)) {
            Vector v = this.getFieldValues(key);
            return (String)v.get(0);
        }
        return "";
    }

    public int numberFields() {
        return this.fields.keySet().size();
    }

    public Vector getFieldValues(String key) {
        return (Vector)this.fields.get(key);
    }

    public String toCSV(ArrayList fields) {
        String ret = "";
        for (int i = 0; i < fields.size(); ++i) {
            String s = this.getFirstValue((String)fields.get(i));
            if (s == null) {
                s = " ";
            }
            s.replaceAll(",", " ");
            ret = ret + s;
            if (i == fields.size() - 1) continue;
            ret = ret + ", ";
        }
        return ret;
    }

    public String toString() {
        if (this.fields == null) {
            return "";
        }
        String ret = "";
        Iterator iter = this.fields.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Vector v = (Vector)this.fields.get(key);
            if (v == null) {
                throw new IllegalStateException(key + " not in hash.");
            }
            ret = ret + key + ": ";
            for (int i = 0; i < v.size(); ++i) {
                ret = ret + (String)v.get(i) + " | ";
            }
            ret = ret + "\n";
        }
        return ret;
    }

    private String removeEndline(String s) {
        return s.replaceAll("ENDLINE", " ").replaceAll(",", " ");
    }

    private boolean filter(String key, String value) {
        if (value.length() > 100) {
            return false;
        }
        Matcher mPhone = PHONE.matcher(key);
        Matcher mEmail = EMAIL.matcher(key);
        Matcher mURL = URL.matcher(key);
        Matcher mLastName = LASTNAME.matcher(key);
        if (mPhone.matches()) {
            Matcher fPhone = F_PHONE.matcher(value);
            if (fPhone.matches()) {
                return true;
            }
            logger.fine(key + ": " + value + " DOESN'T MATCH");
            return false;
        }
        if (mEmail.matches()) {
            Matcher fEmail = F_EMAIL.matcher(value);
            if (fEmail.matches()) {
                return true;
            }
            logger.fine(key + ": " + value + " DOESN'T MATCH");
            return false;
        }
        if (mURL.matches()) {
            Matcher fURL = F_URL.matcher(value);
            if (fURL.matches()) {
                return true;
            }
            logger.fine(key + ": " + value + " DOESN'T MATCH");
            return false;
        }
        if (mLastName.matches()) {
            Matcher fLastName = F_LASTNAME.matcher(value);
            if (fLastName.matches()) {
                return true;
            }
            logger.fine(key + ": " + value + " DOESN'T MATCH");
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.fields);
        out.writeInt(this.names.size());
        for (int i = 0; i < this.names.size(); ++i) {
            out.writeObject((CountedString)this.names.get(i));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.fields = (HashMap)in.readObject();
        int size = in.readInt();
        this.names = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.names.add((CountedString)in.readObject());
        }
    }
}

