/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.types;

import edu.umass.cs.dex.types.People;
import edu.umass.cs.dex.types.Person;
import edu.umass.cs.dex.types.PersonInMessage;
import java.util.Vector;

public class PeopleInMessage {
    public Vector people = new Vector();

    public int size() {
        return this.people.size();
    }

    public PersonInMessage getPerson(int index) {
        return (PersonInMessage)this.people.elementAt(index);
    }

    public People getSimplePeople() {
        Vector<Person> simplePeople = new Vector<Person>();
        for (int i = 0; i < this.people.size(); ++i) {
            PersonInMessage p = (PersonInMessage)this.people.elementAt(i);
            simplePeople.add(p.getSimplePerson());
        }
        return new People(simplePeople);
    }

    public void addPerson(PersonInMessage person) {
        this.people.addElement(person);
        int startSearch = this.people.size() - 1;
        for (int i = startSearch - 1; i >= 0; --i) {
            PersonInMessage p = (PersonInMessage)this.people.elementAt(i);
            if (!p.loginsIntersect(person) && !p.namesIntersect(person)) continue;
            p.mergeTwoPeople(person);
            this.people.remove(startSearch);
            startSearch = i;
            person = p;
        }
    }

    public void buildEmailLinks() {
        for (int i = 0; i < this.people.size(); ++i) {
            PersonInMessage p1 = this.getPerson(i);
            for (int ii = 0; ii < this.people.size(); ++ii) {
                PersonInMessage p2 = this.getPerson(i);
                if (i == ii) continue;
                p1.addEmailLink(p2);
            }
        }
    }

    public void reduceWeights() {
        for (int i = 0; i < this.people.size(); ++i) {
            PersonInMessage p = (PersonInMessage)this.people.elementAt(i);
            double weight = p.getWeight();
            p.changeWeight(weight /= 2.0);
        }
    }

    public void addWordToContextModel(String word) {
        for (int i = 0; i < this.people.size(); ++i) {
            PersonInMessage p = (PersonInMessage)this.people.elementAt(i);
            p.addWordToContextModel(word);
        }
    }
}

