/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.types;

import edu.umass.cs.dex.ie.ContactRecordExtractor;
import edu.umass.cs.dex.ie.EmailPeopleExtractor;
import edu.umass.cs.dex.types.InformationGain;
import edu.umass.cs.dex.types.People;
import edu.umass.cs.dex.types.Person;
import edu.umass.cs.dex.web.HomePageFinder;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;

public class PeopleManager {
    private static Logger logger = MalletLogger.getLogger(PeopleManager.class.getName());
    People people;
    HashSet stopWords;
    String userName;
    File inputDir;
    File inputFile;
    File outputDir;
    File vcfFile;
    File htmlFile;
    File keywordDir;
    File writePeopleFile;
    int maxUrls;

    protected PeopleManager() {
    }

    public PeopleManager(File inputDir, File inputFile, File outputDir, File stopListFile, String userName, File personObjectFile, File vcfFile, File htmlFile, File keywordDir, File writePeopleFile, int maxUrls) {
        this.inputDir = inputDir;
        this.inputFile = inputFile;
        this.outputDir = outputDir;
        this.userName = userName;
        this.vcfFile = vcfFile;
        this.htmlFile = htmlFile;
        this.keywordDir = keywordDir;
        this.maxUrls = maxUrls;
        this.writePeopleFile = writePeopleFile;
        this.setStopWords(stopListFile);
        if (personObjectFile != null) {
            logger.info("Reading people from file " + personObjectFile);
            this.people = People.read(personObjectFile);
        } else if (inputDir != null) {
            logger.info("Reading people from messages in " + inputDir);
            this.readPeopleFromDir(inputDir);
        } else if (inputFile != null) {
            logger.info("Reading people names in " + inputFile);
            this.people = People.readNames(inputFile);
            Iterator iter = this.people.iterator();
            while (iter.hasNext()) {
                logger.info("Read person " + (Person)iter.next());
            }
        } else {
            System.err.println("Must specify either --input-dir or --input file");
            System.exit(-1);
        }
    }

    private void readPeopleFromDir(File inputDir) {
        EmailPeopleExtractor epe = new EmailPeopleExtractor(inputDir, this.stopWords);
        this.people = epe.getPeople();
        logger.info("Read " + this.people.size() + " people from " + inputDir);
    }

    private void setStopWords(File f) {
        this.stopWords = new HashSet();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(f));
            while ((line = reader.readLine()) != null) {
                this.stopWords.add(line.toLowerCase().trim());
            }
        }
        catch (IOException e) {
            System.err.println("Exception reading stop list " + e);
        }
    }

    public void expandSocialNetwork(int numHops, File crfFile) {
        ContactRecordExtractor cre = new ContactRecordExtractor(crfFile, this.vcfFile, this.htmlFile, this.keywordDir, this.stopWords);
        HomePageFinder hpf = new HomePageFinder(this.outputDir, this.userName, this.stopWords, this.maxUrls, 0);
        for (int i = 0; i < numHops; ++i) {
            logger.info("Hop #" + i + ", " + this.people.size() + " people.");
            hpf.findHomePagesFor(this.people, this.writePeopleFile, true);
            logger.info("Completed web search for Hop #" + i + ". Beginning record extraction.");
            cre.extractContactRecordsFor(this.people);
            logger.info("Completed record extraction for Hop #" + i + ". Expanding social network.");
            this.people.expand();
        }
        logger.info("Final network contains " + this.people.size() + " people.");
    }

    public void setKeywords() {
        InformationGain ig = new InformationGain(this.people, this.keywordDir.getAbsolutePath());
    }

    public People getPeople() {
        return this.people;
    }

    public void writePeople(File f) {
        this.people.write(f);
    }

    public void writeTXT(File f) {
        this.people.writeTXT(f);
    }

    public void writeHTML(File f) {
        this.people.writeHTML(f);
    }

    public void writeCSV(File f) {
        this.people.writeCSV(f);
    }

    public void writeVCF(File f) {
        this.people.writeVCF(f);
    }
}

