/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.util;

import edu.umass.cs.mallet.base.fst.Transducer;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.log4j.Priority;

public class MalletLogger
extends Logger {
    private org.apache.log4j.Logger logger;
    static final org.apache.log4j.Logger transducerLogger = org.apache.log4j.Logger.getLogger((Class)Transducer.class);

    public MalletLogger(String name, String resourceBundleName) {
        super("unused", null);
        this.logger = org.apache.log4j.Logger.getLogger((String)name);
    }

    public static final Logger getLogger(String name) {
        return new MalletLogger(name, null);
    }

    public static final Logger getLogger(String name, String resourceBundleName) {
        return new MalletLogger(name, null);
    }

    public ResourceBundle getResourceBundle() {
        return this.logger.getResourceBundle();
    }

    public String getResourceBundleName() {
        this.notSupported("getResourceBundleName - returning empty String");
        return "";
    }

    public void setFilter(Filter newFilter) throws SecurityException {
        this.notSupported("setFilter");
    }

    public Filter getFilter() {
        this.notSupported("getFilter - returning null");
        return null;
    }

    public void log(LogRecord record) {
        this.notSupported("log");
    }

    public void log(Level level, String msg) {
        this.notSupported("log");
    }

    public void log(Level level, String msg, Object param1) {
        this.notSupported("log");
    }

    public void log(Level level, String msg, Object[] params) {
        this.notSupported("log");
    }

    public void log(Level level, String msg, Throwable thrown) {
        this.notSupported("log");
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.notSupported("logp");
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.notSupported("logp");
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.notSupported("logp");
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.notSupported("logp");
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.notSupported("logrb");
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.notSupported("logrb");
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.notSupported("logrb");
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.notSupported("logrb");
    }

    public void entering(String sourceClass, String sourceMethod) {
        this.notSupported("entering");
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.notSupported("entering");
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this.notSupported("entering");
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this.notSupported("exiting");
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.notSupported("exiting");
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.notSupported("throwing");
    }

    public void severe(String msg) {
        this.logger.error((Object)msg);
    }

    public void warning(String msg) {
        this.logger.warn((Object)msg);
    }

    public void info(String msg) {
        this.logger.info((Object)msg);
    }

    public void config(String msg) {
        this.logger.info((Object)msg);
    }

    public void fine(String msg) {
        this.logger.debug((Object)msg);
    }

    public void finer(String msg) {
        this.logger.debug((Object)msg);
    }

    public void finest(String msg) {
        this.logger.debug((Object)msg);
    }

    public void setLevel(Level newLevel) throws SecurityException {
        this.logger.setLevel(this.fromSdkToLog4jLevel(newLevel));
    }

    public Level getLevel() {
        return this.fromLog4jToSdkLevel(this.logger.getEffectiveLevel());
    }

    public boolean isLoggable(Level level) {
        return this.logger.isEnabledFor((Priority)this.fromSdkToLog4jLevel(level));
    }

    public String getName() {
        return this.logger.getName();
    }

    public void addHandler(Handler handler) throws SecurityException {
        this.notSupported("addHandler");
    }

    public void removeHandler(Handler handler) throws SecurityException {
        this.notSupported("removeHandler");
    }

    public Handler[] getHandlers() {
        this.notSupported("getHandlers - returning Handler[0]");
        return new Handler[0];
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this.notSupported("setUseParentHandlers");
    }

    public boolean getUseParentHandlers() {
        this.notSupported("getUseParentHandlers [returning true]");
        return true;
    }

    public Logger getParent() {
        this.notSupported("setParent [returning null]");
        return null;
    }

    public void setParent(Logger parent) {
        this.notSupported("setParent");
    }

    private org.apache.log4j.Level fromSdkToLog4jLevel(Level sdkLevel) {
        if (sdkLevel == Level.ALL) {
            return org.apache.log4j.Level.ALL;
        }
        if (sdkLevel == Level.OFF) {
            return org.apache.log4j.Level.OFF;
        }
        if (sdkLevel == null) {
            return org.apache.log4j.Level.WARN;
        }
        int sdkIntLevel = sdkLevel.intValue();
        if (sdkIntLevel <= Level.FINE.intValue()) {
            return org.apache.log4j.Level.DEBUG;
        }
        if (sdkIntLevel < Level.WARNING.intValue()) {
            return org.apache.log4j.Level.INFO;
        }
        if (sdkIntLevel < Level.SEVERE.intValue()) {
            return org.apache.log4j.Level.WARN;
        }
        return org.apache.log4j.Level.ERROR;
    }

    private Level fromLog4jToSdkLevel(org.apache.log4j.Level log4jLevel) {
        if (log4jLevel == org.apache.log4j.Level.ALL) {
            return Level.ALL;
        }
        if (log4jLevel == org.apache.log4j.Level.OFF) {
            return Level.OFF;
        }
        int log4jIntLevel = log4jLevel.toInt();
        if (log4jIntLevel <= 10000) {
            return Level.FINE;
        }
        if (log4jIntLevel < 30000) {
            return Level.INFO;
        }
        if (log4jIntLevel < 40000) {
            return Level.WARNING;
        }
        return Level.SEVERE;
    }

    private void notSupported(String method) {
        this.logger.error((Object)(this.getClass().getName() + " does not support the java.util.logging.Logger method: " + method));
    }

    static {
        transducerLogger.setLevel(org.apache.log4j.Level.ERROR);
    }
}

