/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.users.culotta.address;

import edu.umass.cs.mallet.base.fst.CRF4;
import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.pipe.SerialPipes;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.Sequence;
import edu.umass.cs.mallet.base.types.TokenSequence;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CRFPipe
extends Pipe
implements Serializable {
    CRF4 crf;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public CRFPipe(File crfFile) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(crfFile));
            this.crf = (CRF4)ois.readObject();
            ois.close();
            System.err.println("Read NER CRF successfully!");
        }
        catch (IOException e) {
            System.err.println("Exception reading file: " + e);
            e.printStackTrace();
            System.exit(-1);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Cound not find class reading in object: " + cnfe);
            System.exit(-2);
        }
        SerialPipes p = (SerialPipes)this.crf.getInputPipe();
        p.removePipe(0);
    }

    public Instance pipe(Instance carrier) {
        if (!(carrier.getData() instanceof TokenSequence)) {
            throw new IllegalArgumentException("Expecting TokenSequence, got " + carrier.getData().getClass().getName());
        }
        TokenSequence ts = (TokenSequence)carrier.getData();
        Instance inst = new Instance((Object)ts, null, null, null, this.crf.getInputPipe());
        Sequence ls = this.crf.viterbiPath((Sequence)inst.getData()).output();
        if (ts.size() != ls.size()) {
            throw new IllegalArgumentException("token sequence size != crf output size");
        }
        for (int i = 0; i < ts.size(); ++i) {
            ts.getToken(i).setFeatureValue("NERTAG=" + ls.get(i).toString(), 1.0);
        }
        carrier.setData((Object)ts);
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.crf);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.crf = (CRF4)in.readObject();
    }
}

