/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.mail.MailMessage;

public class SendEmail
extends Task {
    private String from;
    private String mailhost = "localhost";
    private String message;
    private String toList;
    private String subject;
    private Vector files = new Vector();

    public void setToList(String string) {
        this.toList = string;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public void setMailhost(String string) {
        this.mailhost = string;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public void setFiles(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            this.files.addElement(this.project.resolveFile(stringTokenizer.nextToken()));
        }
    }

    public void execute() {
        try {
            Object object;
            MailMessage mailMessage = new MailMessage(this.mailhost);
            if (this.from == null) {
                throw new BuildException("Attribute \"from\" is required.");
            }
            mailMessage.from(this.from);
            if (this.toList != null) {
                object = new StringTokenizer(this.toList, ", ", false);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    mailMessage.to(((StringTokenizer)object).nextToken());
                }
            } else {
                throw new BuildException("Attribute \"toList\" is required.");
            }
            if (this.subject != null) {
                mailMessage.setSubject(this.subject);
            }
            if (!this.files.isEmpty()) {
                object = mailMessage.getPrintStream();
                Enumeration enumeration = this.files.elements();
                while (enumeration.hasMoreElements()) {
                    File file = (File)enumeration.nextElement();
                    if (file.exists() && file.canRead()) {
                        Object var10_10;
                        int n = 1024;
                        byte[] byArray = new byte[n];
                        BufferedInputStream bufferedInputStream = null;
                        try {
                            int n2;
                            bufferedInputStream = new BufferedInputStream(new FileInputStream(file), n);
                            while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                                ((PrintStream)object).write(byArray, 0, n2);
                            }
                            var10_10 = null;
                            if (bufferedInputStream == null) continue;
                        }
                        catch (Throwable throwable) {
                            var10_10 = null;
                            if (bufferedInputStream != null) {
                                bufferedInputStream.close();
                            }
                            throw throwable;
                        }
                        bufferedInputStream.close();
                        {
                            continue;
                        }
                    }
                    throw new BuildException("File \"" + file.getName() + "\" does not exist or is not readable.");
                }
            } else if (this.message != null) {
                object = mailMessage.getPrintStream();
                ((PrintStream)object).print(this.message);
            } else {
                throw new BuildException("Attribute \"file\" or \"message\" is required.");
            }
            this.log("Sending email");
            mailMessage.sendAndClose();
        }
        catch (IOException iOException) {
            throw new BuildException("IO error sending mail: " + iOException.getMessage());
        }
    }
}

