/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.BagOfTokens;
import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.tokens.SimpleTokenizer;
import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.Iterator;

public class Jaccard
extends AbstractStringDistance {
    private Tokenizer tokenizer;

    public Jaccard(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public Jaccard() {
        this(SimpleTokenizer.DEFAULT_TOKENIZER);
    }

    public double score(StringWrapper s, StringWrapper t) {
        BagOfTokens sBag = (BagOfTokens)s;
        BagOfTokens tBag = (BagOfTokens)t;
        double numCommon = 0.0;
        Iterator i = sBag.tokenIterator();
        while (i.hasNext()) {
            Token tok = (Token)i.next();
            if (!tBag.contains(tok)) continue;
            numCommon += 1.0;
        }
        return numCommon / ((double)(sBag.size() + tBag.size()) - numCommon);
    }

    public StringWrapper prepare(String s) {
        return new BagOfTokens(s, this.tokenizer.tokenize(s));
    }

    public String explainScore(StringWrapper s, StringWrapper t) {
        Token tok;
        BagOfTokens sBag = (BagOfTokens)s;
        BagOfTokens tBag = (BagOfTokens)t;
        StringBuffer buf = new StringBuffer("");
        buf.append("S: ");
        Iterator i = sBag.tokenIterator();
        while (i.hasNext()) {
            tok = (Token)i.next();
            buf.append(" " + tok.getValue());
            if (!tBag.contains(tok)) continue;
            buf.append("*");
        }
        buf.append("\nT: ");
        i = tBag.tokenIterator();
        while (i.hasNext()) {
            tok = (Token)i.next();
            buf.append(" " + tok.getValue());
            if (!sBag.contains(tok)) continue;
            buf.append("*");
        }
        buf.append("\nscore = " + this.score(s, t));
        return buf.toString();
    }

    public String toString() {
        return "[Jaccard]";
    }

    public static void main(String[] argv) {
        Jaccard.doMain(new Jaccard(), argv);
    }
}

