/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.graph;

import edu.umass.cs.dex.graph.PeopleGraph;
import edu.umass.cs.dex.types.People;
import edu.umass.cs.dex.types.Person;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class TestPeopleGraph {
    public static void main(String[] args) throws Exception {
        PeopleGraph pg = null;
        if (args.length == 0) {
            pg = TestPeopleGraph.createPeopleGraph();
        } else {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(new File(args[0])));
                pg = (PeopleGraph)((Object)ois.readObject());
                ois.close();
                System.err.println("Read PeopleGraph successfully!");
            }
            catch (IOException e) {
                System.err.println("Exception reading file: " + e);
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("Cound not find class reading in object: " + cnfe);
            }
        }
        System.out.println("Testing on graph " + (Object)((Object)pg));
        pg.printAllStatistics(new File("test.dat"));
    }

    public static PeopleGraph createPeopleGraph() throws Exception {
        People people = new People();
        int npeople = 5;
        Person p0 = new Person("0", "0", "");
        Person p1 = new Person("1", "1", "");
        Person p2 = new Person("2", "2", "");
        Person p3 = new Person("3", "3", "");
        Person p4 = new Person("4", "4", "");
        Person p5 = new Person("5", "5", "");
        Person p6 = new Person("6", "6", "");
        Person p7 = new Person("7", "7", "");
        people.addPerson(p0);
        people.addPerson(p1);
        people.addPerson(p2);
        people.addPerson(p3);
        people.addPerson(p4);
        people.addPerson(p5);
        people.addPerson(p6);
        people.addPerson(p7);
        p0.addOutLink(2);
        p0.addOutLink(1);
        p4.addOutLink(0);
        p1.addOutLink(3);
        p3.addOutLink(5);
        p3.addOutLink(6);
        p5.addOutLink(7);
        p0.addKeyWord("word0");
        p1.addKeyWord("word0");
        p2.addKeyWord("word2");
        p3.addKeyWord("word3");
        p4.addKeyWord("word4");
        p5.addKeyWord("word5");
        p6.addKeyWord("word6");
        p7.addKeyWord("word7");
        return new PeopleGraph(people);
    }
}

