/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import weka.core.Utils;

public class ExperimenterDefaults
implements Serializable {
    public static final String PROPERTY_FILE = "weka/gui/experiment/Experimenter.props";
    protected static Properties PROPERTIES;

    public static String get(String string, String string2) {
        return PROPERTIES.getProperty(string, string2);
    }

    public static final Properties getProperties() {
        return PROPERTIES;
    }

    public static final String getExtension() {
        return ExperimenterDefaults.get("Extension", ".exp");
    }

    public static final String getDestination() {
        return ExperimenterDefaults.get("Destination", "ARFF file");
    }

    public static final String getExperimentType() {
        return ExperimenterDefaults.get("ExperimentType", "Cross-validation");
    }

    public static final boolean getUseClassification() {
        return Boolean.valueOf(ExperimenterDefaults.get("UseClassification", "true"));
    }

    public static final int getFolds() {
        return Integer.parseInt(ExperimenterDefaults.get("Folds", "10"));
    }

    public static final double getTrainPercentage() {
        return Integer.parseInt(ExperimenterDefaults.get("TrainPercentage", "66"));
    }

    public static final int getRepetitions() {
        return Integer.parseInt(ExperimenterDefaults.get("Repetitions", "10"));
    }

    public static final boolean getDatasetsFirst() {
        return Boolean.valueOf(ExperimenterDefaults.get("DatasetsFirst", "true"));
    }

    public static final File getInitialDatasetsDirectory() {
        String string = ExperimenterDefaults.get("InitialDatasetsDirectory", "");
        if (string.equals("")) {
            string = System.getProperty("user.dir");
        }
        return new File(string);
    }

    public static final boolean getUseRelativePaths() {
        return Boolean.valueOf(ExperimenterDefaults.get("UseRelativePaths", "false"));
    }

    public static final String getRow() {
        return ExperimenterDefaults.get("Row", "1");
    }

    public static final String getColumn() {
        return ExperimenterDefaults.get("Column", "3,4,5");
    }

    public static final String getComparisonField() {
        return ExperimenterDefaults.get("ComparisonField", "percent_correct");
    }

    public static final double getSignificance() {
        return Double.parseDouble(ExperimenterDefaults.get("Significance", "0.05"));
    }

    public static final boolean getShowStdDevs() {
        return Boolean.valueOf(ExperimenterDefaults.get("ShowStdDev", "false"));
    }

    public static final int getMeanPrecision() {
        return Integer.parseInt(ExperimenterDefaults.get("MeanPrecision", "2"));
    }

    public static final int getStdDevPrecision() {
        return Integer.parseInt(ExperimenterDefaults.get("StdDevPrecision", "2"));
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
        }
        catch (Exception exception) {
            System.err.println("Problem reading properties. Fix before continuing.");
            exception.printStackTrace();
            PROPERTIES = new Properties();
        }
    }
}

