/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import org.python.parser.SimpleNode;
import org.python.parser.ast.VisitorIF;
import org.python.parser.ast.exprType;
import org.python.parser.ast.stmtType;

public class If
extends stmtType {
    public exprType test;
    public stmtType[] body;
    public stmtType[] orelse;

    public If(exprType test, stmtType[] body, stmtType[] orelse) {
        this.test = test;
        this.body = body;
        this.orelse = orelse;
    }

    public If(exprType test, stmtType[] body, stmtType[] orelse, SimpleNode parent) {
        this(test, body, orelse);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("If[");
        sb.append("test=");
        sb.append(this.dumpThis(this.test));
        sb.append(", ");
        sb.append("body=");
        sb.append(this.dumpThis(this.body));
        sb.append(", ");
        sb.append("orelse=");
        sb.append(this.dumpThis(this.orelse));
        sb.append("]");
        return sb.toString();
    }

    public void pickle(DataOutputStream ostream) throws IOException {
        this.pickleThis(15, ostream);
        this.pickleThis(this.test, ostream);
        this.pickleThis(this.body, ostream);
        this.pickleThis(this.orelse, ostream);
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitIf(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        int i;
        if (this.test != null) {
            this.test.accept(visitor);
        }
        if (this.body != null) {
            for (i = 0; i < this.body.length; ++i) {
                if (this.body[i] == null) continue;
                this.body[i].accept(visitor);
            }
        }
        if (this.orelse != null) {
            for (i = 0; i < this.orelse.length; ++i) {
                if (this.orelse[i] == null) continue;
                this.orelse[i].accept(visitor);
            }
        }
    }
}

