/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics.tui;

import cc.mallet.pipe.CharSequence2TokenSequence;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.TargetStringToFeatures;
import cc.mallet.pipe.TokenSequence2FeatureSequence;
import cc.mallet.pipe.TokenSequenceLowercase;
import cc.mallet.pipe.TokenSequenceRemoveStopwords;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;

public class DMRLoader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public static BufferedReader openReader(File file) throws IOException {
        BufferedReader reader = null;
        reader = file.toString().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file)))) : new BufferedReader(new FileReader(file));
        return reader;
    }

    public void load(File wordsFile, File featuresFile, File instancesFile) throws IOException, FileNotFoundException {
        SerialPipes instancePipe = new SerialPipes(new Pipe[]{new TargetStringToFeatures(), new CharSequence2TokenSequence(), new TokenSequenceLowercase(), new TokenSequenceRemoveStopwords(false, false), new TokenSequence2FeatureSequence()});
        InstanceList instances = new InstanceList(instancePipe);
        ArrayList<Instance> instanceBuffer = new ArrayList<Instance>();
        BufferedReader wordsReader = DMRLoader.openReader(wordsFile);
        BufferedReader featuresReader = DMRLoader.openReader(featuresFile);
        int lineNumber = 1;
        String wordsLine = null;
        String featuresLine = null;
        while ((wordsLine = wordsReader.readLine()) != null) {
            featuresLine = featuresReader.readLine();
            if (featuresLine == null) {
                System.err.println("ran out of features");
                System.exit(0);
            }
            if (featuresLine.equals("")) continue;
            instanceBuffer.add(new Instance(wordsLine, featuresLine, String.valueOf(lineNumber), null));
            ++lineNumber;
        }
        instances.addThruPipe(instanceBuffer.iterator());
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(instancesFile)));
        oos.writeObject(instances);
        oos.close();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length != 3) {
            System.err.println("Usage: DMRLoader [words file] [features file] [instances file]");
            System.exit(0);
        }
        File wordsFile = new File(args[0]);
        File featuresFile = new File(args[1]);
        File instancesFile = new File(args[2]);
        DMRLoader loader = new DMRLoader();
        loader.load(wordsFile, featuresFile, instancesFile);
    }
}

