/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import java.util.Vector;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.StringSubstitution;

public class Perl5Substitution
extends StringSubstitution {
    public static final int INTERPOLATE_ALL = 0;
    public static final int INTERPOLATE_NONE = -1;
    int _numInterpolations;
    Vector _substitutions;
    transient String _lastInterpolation;

    static Vector _parseSubs(String sub) {
        Vector<Object> subs = new Vector<Object>(5);
        StringBuffer numBuffer = new StringBuffer(5);
        StringBuffer strBuffer = new StringBuffer(10);
        char[] str = sub.toCharArray();
        boolean saveDigits = false;
        boolean storedInterpolation = false;
        for (int current = 0; current < str.length; ++current) {
            if (saveDigits && Character.isDigit(str[current])) {
                numBuffer.append(str[current]);
                if (strBuffer.length() <= 0) continue;
                subs.addElement(strBuffer.toString());
                strBuffer.setLength(0);
                continue;
            }
            if (saveDigits) {
                try {
                    subs.addElement(new Integer(numBuffer.toString()));
                    storedInterpolation = true;
                }
                catch (NumberFormatException e) {
                    subs.addElement(numBuffer.toString());
                }
                numBuffer.setLength(0);
                saveDigits = false;
            }
            if (str[current] == '$' && current + 1 < str.length && str[current + 1] != '0' && Character.isDigit(str[current + 1])) {
                saveDigits = true;
                continue;
            }
            strBuffer.append(str[current]);
        }
        if (saveDigits) {
            try {
                subs.addElement(new Integer(numBuffer.toString()));
                storedInterpolation = true;
            }
            catch (NumberFormatException e) {
                subs.addElement(numBuffer.toString());
            }
        } else if (strBuffer.length() > 0) {
            subs.addElement(strBuffer.toString());
        }
        return storedInterpolation ? subs : null;
    }

    String _finalInterpolatedSub(MatchResult result) {
        StringBuffer buffer = new StringBuffer(10);
        this._calcSub(buffer, result);
        return buffer.toString();
    }

    void _calcSub(StringBuffer buffer, MatchResult result) {
        int size = this._substitutions.size();
        for (int element = 0; element < size; ++element) {
            Object obj = this._substitutions.elementAt(element);
            if (obj instanceof String) {
                buffer.append(obj);
                continue;
            }
            Integer integer = (Integer)obj;
            int value = integer;
            if (value > 0 && value < result.groups()) {
                String group = result.group(value);
                if (group == null) continue;
                buffer.append(group);
                continue;
            }
            buffer.append('$');
            buffer.append(value);
        }
    }

    public Perl5Substitution() {
        this("", 0);
    }

    public Perl5Substitution(String substitution) {
        this(substitution, 0);
    }

    public Perl5Substitution(String substitution, int numInterpolations) {
        this.setSubstitution(substitution, numInterpolations);
    }

    public void setSubstitution(String substitution) {
        this.setSubstitution(substitution, 0);
    }

    public void setSubstitution(String substitution, int numInterpolations) {
        super.setSubstitution(substitution);
        this._numInterpolations = numInterpolations;
        this._substitutions = numInterpolations != -1 && substitution.indexOf(36) != -1 ? Perl5Substitution._parseSubs(substitution) : null;
        this._lastInterpolation = null;
    }

    public void appendSubstitution(StringBuffer appendBuffer, MatchResult match, int substitutionCount, String originalInput, PatternMatcher matcher, Pattern pattern) {
        if (this._substitutions == null) {
            super.appendSubstitution(appendBuffer, match, substitutionCount, originalInput, matcher, pattern);
            return;
        }
        if (this._numInterpolations < 1 || substitutionCount < this._numInterpolations) {
            this._calcSub(appendBuffer, match);
        } else {
            if (substitutionCount == this._numInterpolations) {
                this._lastInterpolation = this._finalInterpolatedSub(match);
            }
            appendBuffer.append(this._lastInterpolation);
        }
    }
}

