/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;

public class PyXRange
extends PySequence {
    public int start;
    public int stop;
    public int step;
    int cycleLength;
    int copies;

    public PyXRange(int start, int stop, int step) {
        if (step == 0) {
            throw Py.ValueError("zero step for xrange()");
        }
        this.start = start;
        this.stop = stop;
        this.step = step;
        int oneLessThanStep = step + (step > 0 ? -1 : 1);
        this.cycleLength = (stop - start + oneLessThanStep) / step;
        if (this.cycleLength < 0) {
            this.cycleLength = 0;
        }
        this.stop = start + this.cycleLength * step;
        this.copies = 1;
    }

    public int __len__() {
        return this.cycleLength * this.copies;
    }

    private int getInt(int i) {
        if (this.cycleLength == 0) {
            return this.start;
        }
        return this.start + i % this.cycleLength * this.step;
    }

    protected PyObject pyget(int i) {
        return new PyInteger(this.getInt(i));
    }

    protected PyObject getslice(int start, int stop, int step) {
        Py.DeprecationWarning("xrange object slicing is deprecated; convert to list instead");
        if (this.copies != 1) {
            throw Py.TypeError("cannot slice a replicated range");
        }
        int len = PyXRange.sliceLength(start, stop, step);
        int xslice_start = this.getInt(start);
        int xslice_step = this.step * step;
        int xslice_stop = xslice_start + xslice_step * len;
        return new PyXRange(xslice_start, xslice_stop, xslice_step);
    }

    protected PyObject repeat(int howmany) {
        Py.DeprecationWarning("xrange object multiplication is deprecated; convert to list instead");
        PyXRange x = new PyXRange(this.start, this.stop, this.step);
        x.copies = this.copies * howmany;
        return x;
    }

    public PyObject __add__(PyObject generic_other) {
        throw Py.TypeError("cannot concatenate xrange objects");
    }

    public PyObject __findattr__(String name) {
        String msg = "xrange object's 'start', 'stop' and 'step' attributes are deprecated";
        if (name == "start") {
            Py.DeprecationWarning(msg);
            return Py.newInteger(this.start);
        }
        if (name == "stop") {
            Py.DeprecationWarning(msg);
            return Py.newInteger(this.stop);
        }
        if (name == "step") {
            Py.DeprecationWarning(msg);
            return Py.newInteger(this.step);
        }
        return super.__findattr__(name);
    }

    public int hashCode() {
        return this.stop ^ this.start ^ this.step;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("xrange(");
        if (this.start != 0) {
            buf.append(this.start);
            buf.append(", ");
        }
        buf.append(this.__len__() * this.step + this.start);
        if (this.step != 1) {
            buf.append(", ");
            buf.append(this.step);
        }
        buf.append(")");
        return buf.toString();
    }

    public PyList tolist() {
        Py.DeprecationWarning("xrange.tolist() is deprecated; use list(xrange) instead");
        PyList list = new PyList();
        int count = this.__len__();
        for (int i = 0; i < count; ++i) {
            list.append(this.pyget(i));
        }
        return list;
    }
}

