/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.generate;

import java.util.Map;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.VertexFactory;
import org._3pq.jgrapht.generate.GraphGenerator;

public class LinearGraphGenerator
implements GraphGenerator {
    public static final String START_VERTEX = "Start Vertex";
    public static final String END_VERTEX = "End Vertex";
    private int m_size;

    public LinearGraphGenerator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.m_size = n;
    }

    public void generateGraph(Graph graph, VertexFactory vertexFactory, Map map) {
        Object object = null;
        for (int i = 0; i < this.m_size; ++i) {
            Object object2 = vertexFactory.createVertex();
            graph.addVertex(object2);
            if (object == null) {
                if (map != null) {
                    map.put(START_VERTEX, object2);
                }
            } else {
                graph.addEdge(object, object2);
            }
            object = object2;
        }
        if (map != null && object != null) {
            map.put(END_VERTEX, object);
        }
    }
}

