/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.web;

import com.google.soap.search.GoogleSearchFault;
import edu.umass.cs.dex.web.GoogleInvalidLicenseKeyException;
import edu.umass.cs.dex.web.GoogleQueryLimitExceededException;
import edu.umass.cs.dex.web.GoogleRuntimeException;
import java.util.regex.Pattern;

public class GoogleExceptionConversionUtility {
    private static final Pattern INVALID_AUTHORIZATION_KEY_PATTERN = Pattern.compile(".*Invalid authorization key.*", 32);
    private static final Pattern DAILY_LIMIT_EXCEEDED_PATTERN = Pattern.compile(".*Daily limit of [0-9]+ queries exceeded.*", 32);

    public static GoogleRuntimeException convert(GoogleSearchFault gsf, String msg) {
        String faultMsg = gsf.getMessage();
        if (faultMsg != null) {
            if (INVALID_AUTHORIZATION_KEY_PATTERN.matcher(faultMsg).matches()) {
                return new GoogleInvalidLicenseKeyException(msg, gsf);
            }
            if (DAILY_LIMIT_EXCEEDED_PATTERN.matcher(faultMsg).matches()) {
                return new GoogleQueryLimitExceededException(msg, gsf);
            }
        }
        return new GoogleRuntimeException(msg, gsf);
    }
}

