/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.web;

import edu.umass.cs.dex.types.CountedString;
import edu.umass.cs.dex.types.Person;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Query {
    private static Logger logger = MalletLogger.getLogger(Query.class.getName());
    private int minOccurrences;

    public Query(int num) {
        this.minOccurrences = num;
    }

    private Vector buildQueriesWithDomainFields(Vector queries, String name, Vector domains, int numOfFields) {
        Vector<String> currentDomains = new Vector<String>();
        for (int i = 0; i < domains.size(); ++i) {
            String domain = ((CountedString)domains.elementAt((int)i)).str;
            Pattern pat = Pattern.compile("\\.");
            String[] fields = pat.split(domain);
            domain = "";
            if (fields.length < numOfFields) continue;
            for (int j = numOfFields; j > 1; --j) {
                domain = domain + fields[fields.length - j] + ".";
            }
            domain = domain + fields[fields.length - 1];
            for (int ii = 0; ii < currentDomains.size(); ++ii) {
                String currentDomain = (String)currentDomains.get(ii);
                if (!currentDomain.equals(domain)) continue;
            }
            currentDomains.add(domain);
            String query = "\"" + name + "\" site:" + domain;
            logger.fine("Query: " + query);
            queries.add(query);
        }
        return queries;
    }

    public Vector buildQueries(Person person, boolean isWideSearch) {
        String surname;
        String name;
        int i;
        Vector queries = new Vector();
        if (person.getNumberOfOccurrences() <= this.minOccurrences) {
            return queries;
        }
        if (person.names.size() == 0) {
            return queries;
        }
        for (i = 0; i < person.names.size() && i < 3; ++i) {
            name = ((CountedString)person.names.elementAt((int)i)).str;
            queries = this.buildQueriesWithDomainFields(queries, name, person.domains, 3);
            queries = this.buildQueriesWithDomainFields(queries, name, person.domains, 2);
        }
        if (isWideSearch) {
            for (i = 0; i < person.names.size() && i < 3; ++i) {
                name = ((CountedString)person.names.elementAt((int)i)).str;
                if (name.indexOf(" ") == -1) continue;
                String query = "\"" + name + "\"";
                logger.fine("Query: " + query);
                queries.add(query);
            }
        }
        if ((surname = person.getSurname()) != null) {
            queries = this.buildQueriesWithDomainFields(queries, surname, person.domains, 3);
        }
        logger.info("Searching web for " + person);
        return queries;
    }
}

