/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.fst.MaxLatticeDefault;
import cc.mallet.fst.Segment;
import cc.mallet.fst.Transducer;
import cc.mallet.pipe.Noop;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentIterator
implements Iterator<Instance> {
    Iterator subIterator;
    ArrayList segments;

    public SegmentIterator(Transducer model, InstanceList ilist, Object[] segmentStartTags, Object[] segmentContinueTags) {
        this.setSubIterator(model, ilist, segmentStartTags, segmentContinueTags);
    }

    public SegmentIterator(Transducer model, Instance instance, Object[] segmentStartTags, Object[] segmentContinueTags) {
        InstanceList ilist = new InstanceList(new Noop(instance.getDataAlphabet(), instance.getTargetAlphabet()));
        ilist.add(instance);
        this.setSubIterator(model, ilist, segmentStartTags, segmentContinueTags);
    }

    public SegmentIterator(InstanceList ilist, Object[] startTags, Object[] inTags, ArrayList predictions) {
        this.setSubIterator(ilist, startTags, inTags, predictions);
    }

    public SegmentIterator(Instance instance, Object[] startTags, Object[] inTags, Sequence prediction) {
        InstanceList ilist = new InstanceList(new Noop(instance.getDataAlphabet(), instance.getTargetAlphabet()));
        ilist.add(instance);
        ArrayList<Sequence> predictions = new ArrayList<Sequence>();
        predictions.add(prediction);
        this.setSubIterator(ilist, startTags, inTags, predictions);
    }

    public SegmentIterator(Sequence input, Sequence predicted, Sequence truth, Object[] startTags, Object[] inTags) {
        this.segments = new ArrayList();
        if (input.size() != truth.size() || predicted.size() != truth.size()) {
            throw new IllegalStateException("sequence lengths not equal. input: " + input.size() + " true: " + truth.size() + " predicted: " + predicted.size());
        }
        for (int n = 0; n < predicted.size(); ++n) {
            for (int s = 0; s < startTags.length; ++s) {
                int j;
                if (!startTags[s].equals(predicted.get(n))) continue;
                for (j = n + 1; j < predicted.size() && inTags[s].equals(predicted.get(j)); ++j) {
                }
                this.segments.add(new Segment(input, predicted, truth, n, j - 1, startTags[s], inTags[s]));
            }
        }
        this.subIterator = this.segments.iterator();
    }

    private void setSubIterator(InstanceList ilist, Object[] startTags, Object[] inTags, ArrayList predictions) {
        this.segments = new ArrayList();
        Iterator iter = ilist.iterator();
        for (int i = 0; i < ilist.size(); ++i) {
            Instance instance = (Instance)ilist.get(i);
            Sequence input = (Sequence)instance.getData();
            Sequence trueOutput = (Sequence)instance.getTarget();
            Sequence predOutput = (Sequence)predictions.get(i);
            if (input.size() != trueOutput.size() || predOutput.size() != trueOutput.size()) {
                throw new IllegalStateException("sequence lengths not equal. input: " + input.size() + " true: " + trueOutput.size() + " predicted: " + predOutput.size());
            }
            for (int n = 0; n < predOutput.size(); ++n) {
                for (int s = 0; s < startTags.length; ++s) {
                    int j;
                    if (!startTags[s].equals(predOutput.get(n))) continue;
                    for (j = n + 1; j < predOutput.size() && inTags[s].equals(predOutput.get(j)); ++j) {
                    }
                    this.segments.add(new Segment(input, predOutput, trueOutput, n, j - 1, startTags[s], inTags[s]));
                }
            }
        }
        this.subIterator = this.segments.iterator();
    }

    private void setSubIterator(Transducer model, InstanceList ilist, Object[] segmentStartTags, Object[] segmentContinueTags) {
        this.segments = new ArrayList();
        for (Instance instance : ilist) {
            Sequence input = (Sequence)instance.getData();
            Sequence trueOutput = (Sequence)instance.getTarget();
            Sequence<Object> predOutput = new MaxLatticeDefault(model, input).bestOutputSequence();
            if (input.size() != trueOutput.size() || predOutput.size() != trueOutput.size()) {
                throw new IllegalStateException("sequence lengths not equal. input: " + input.size() + " true: " + trueOutput.size() + " predicted: " + predOutput.size());
            }
            for (int i = 0; i < predOutput.size(); ++i) {
                for (int s = 0; s < segmentStartTags.length; ++s) {
                    int j;
                    if (!segmentStartTags[s].equals(predOutput.get(i))) continue;
                    for (j = i + 1; j < predOutput.size() && segmentContinueTags[s].equals(predOutput.get(j)); ++j) {
                    }
                    this.segments.add(new Segment(input, predOutput, trueOutput, i, j - 1, segmentStartTags[s], segmentContinueTags[s]));
                }
            }
        }
        this.subIterator = this.segments.iterator();
    }

    @Override
    public Instance next() {
        Segment nextSegment = (Segment)this.subIterator.next();
        return new Instance(nextSegment, nextSegment.getTruth(), null, null);
    }

    public Segment nextSegment() {
        return (Segment)this.subIterator.next();
    }

    @Override
    public boolean hasNext() {
        return this.subIterator.hasNext();
    }

    public ArrayList toArrayList() {
        return this.segments;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }
}

