/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tests;

import cc.mallet.pipe.CharSequence2TokenSequence;
import cc.mallet.pipe.FeatureSequence2FeatureVector;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.PrintInput;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.TokenSequence2FeatureSequence;
import cc.mallet.pipe.TokenSequence2TokenInstances;
import cc.mallet.pipe.TokenSequenceLowercase;
import cc.mallet.pipe.iterator.ArrayIterator;
import cc.mallet.pipe.iterator.StringArrayIterator;
import cc.mallet.pipe.tsf.RegexMatches;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.tests.TestSerializable;
import java.io.IOException;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestInstancePipe
extends TestCase {
    String[] data = new String[]{"This is the first test string", "The second test string is here", "And this is the third test string"};

    public TestInstancePipe(String name) {
        super(name);
    }

    public Pipe createPipe() {
        return new SerialPipes(new Pipe[]{new CharSequence2TokenSequence(), new TokenSequenceLowercase(), new TokenSequence2FeatureSequence(), new FeatureSequence2FeatureVector()});
    }

    public void testOne() {
        Pipe p = this.createPipe();
        InstanceList ilist = new InstanceList(p);
        ilist.addThruPipe(new StringArrayIterator(this.data));
        TestInstancePipe.assertTrue((ilist.size() == 3 ? 1 : 0) != 0);
    }

    public void testTwo() {
        SerialPipes p = new SerialPipes(new Pipe[]{new CharSequence2TokenSequence(), new TokenSequenceLowercase(), new RegexMatches("vowel", Pattern.compile("[aeiou]")), new RegexMatches("firsthalf", Pattern.compile("[a-m]")), new RegexMatches("secondhalf", Pattern.compile("[n-z]")), new RegexMatches("length2", Pattern.compile("..")), new RegexMatches("length3", Pattern.compile("...")), new PrintInput(), new TokenSequence2TokenInstances()});
        InstanceList ilist = new InstanceList(p);
        ilist.addThruPipe(new StringArrayIterator(this.data));
        assert (ilist.size() == 19) : "list size = " + ilist.size();
        TestInstancePipe.assertTrue((ilist.size() == 19 ? 1 : 0) != 0);
    }

    public void testOneFromSerialized() throws IOException, ClassNotFoundException {
        Pipe p = this.createPipe();
        Pipe clone = (Pipe)TestSerializable.cloneViaSerialization(p);
        InstanceList ilist = new InstanceList(clone);
        ilist.addThruPipe(new StringArrayIterator(this.data));
        TestInstancePipe.assertTrue((ilist.size() == 3 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(TestInstancePipe.class);
    }

    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestInstancePipe.suite());
    }

    public static class Array2ArrayIterator
    extends Pipe {
        public Instance pipe(Instance carrier) {
            carrier.setData(new ArrayIterator((Object[])carrier.getData()));
            return carrier;
        }
    }
}

