/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.distributed;

import java.util.Iterator;
import no.uib.cipr.matrix.AbstractVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.distributed.Communicator;
import no.uib.cipr.matrix.distributed.Reductions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistVector
extends AbstractVector {
    private static final long serialVersionUID = 4048795671438309432L;
    private Communicator comm;
    Vector x;
    int[] n;
    int rank;
    private int commSize;

    public DistVector(int size, Communicator comm, Vector x) {
        super(size);
        this.comm = comm;
        this.x = x;
        this.rank = comm.rank();
        this.commSize = comm.size();
        this.n = new int[this.commSize + 1];
        int[] send = new int[]{x.size()};
        int[][] recv = new int[comm.size()][1];
        comm.allGather(send, (Object[])recv);
        for (int i = 0; i < this.commSize; ++i) {
            this.n[i + 1] = this.n[i] + recv[i][0];
        }
        if (this.n[this.commSize] != size) {
            throw new IllegalArgumentException("Sum of local vector sizes (" + this.n[this.commSize] + ") do not match the global vector size (" + size + ")");
        }
    }

    @Override
    public void set(int index, double value) {
        this.check(index);
        if (!this.local(index)) {
            throw new IllegalArgumentException("Index " + index + " is not local");
        }
        this.x.set(index - this.n[this.rank], value);
    }

    @Override
    public void add(int index, double value) {
        this.check(index);
        if (!this.local(index)) {
            throw new IllegalArgumentException("Index " + index + " is not local");
        }
        this.x.add(index - this.n[this.rank], value);
    }

    @Override
    public double get(int index) {
        this.check(index);
        if (this.local(index)) {
            return this.x.get(index - this.n[this.rank]);
        }
        throw new IllegalArgumentException("Entry not available locally");
    }

    @Override
    public DistVector copy() {
        return new DistVector(this.size, this.comm, this.x.copy());
    }

    @Override
    public DistVector zero() {
        this.x.zero();
        return this;
    }

    @Override
    public DistVector scale(double alpha) {
        this.x.scale(alpha);
        return this;
    }

    @Override
    public DistVector set(double alpha, Vector y) {
        if (!(y instanceof DistVector)) {
            throw new IllegalArgumentException("Vector must be DistVector");
        }
        this.checkSize(y);
        Vector yb = ((DistVector)y).getLocal();
        this.x.set(alpha, yb);
        return this;
    }

    @Override
    public DistVector add(double alpha, Vector y) {
        if (!(y instanceof DistVector)) {
            throw new IllegalArgumentException("Vector must be DistVector");
        }
        this.checkSize(y);
        Vector yb = ((DistVector)y).getLocal();
        this.x.add(alpha, yb);
        return this;
    }

    @Override
    public double dot(Vector y) {
        if (!(y instanceof DistVector)) {
            throw new IllegalArgumentException("Vector must be a DistVector");
        }
        this.checkSize(y);
        Vector yb = ((DistVector)y).getLocal();
        double ldot = this.x.dot(yb);
        double[] recv = new double[1];
        this.comm.allReduce(new double[]{ldot}, recv, Reductions.sum());
        return recv[0];
    }

    @Override
    protected double norm1() {
        double norm = this.x.norm(Vector.Norm.One);
        double[] recv = new double[1];
        this.comm.allReduce(new double[]{norm}, recv, Reductions.sum());
        return norm;
    }

    @Override
    protected double norm2_robust() {
        return this.norm2();
    }

    @Override
    protected double norm2() {
        double norm = this.x.norm(Vector.Norm.Two);
        norm *= norm;
        double[] recv = new double[1];
        this.comm.allReduce(new double[]{norm}, recv, Reductions.sum());
        return Math.sqrt(recv[0]);
    }

    @Override
    protected double normInf() {
        double norm = this.x.norm(Vector.Norm.Infinity);
        double[] recv = new double[1];
        this.comm.allReduce(new double[]{norm}, recv, Reductions.max());
        return norm;
    }

    public Vector getLocal() {
        return this.x;
    }

    public int[] getOwnerships() {
        return this.n;
    }

    public boolean local(int index) {
        return index >= this.n[this.rank] && index < this.n[this.rank + 1];
    }

    @Override
    public Iterator<VectorEntry> iterator() {
        return new DistVectorIterator();
    }

    public Communicator getCommunicator() {
        return this.comm;
    }

    private class DistVectorEntry
    implements VectorEntry {
        private int offset;
        private VectorEntry e;

        public DistVectorEntry() {
            this.offset = DistVector.this.n[DistVector.this.rank];
        }

        public void update(VectorEntry e) {
            this.e = e;
        }

        public int index() {
            return this.e.index() + this.offset;
        }

        public double get() {
            return this.e.get();
        }

        public void set(double value) {
            this.e.set(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistVectorIterator
    implements Iterator<VectorEntry> {
        private DistVectorEntry entry;
        private Iterator<VectorEntry> i;

        public DistVectorIterator() {
            this.i = DistVector.this.x.iterator();
            this.entry = new DistVectorEntry();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public VectorEntry next() {
            this.entry.update(this.i.next());
            return this.entry;
        }
    }
}

