/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.modules.MatchObject;
import org.python.modules.re;

public class RegexObject
extends PyObject {
    private static Perl5Compiler compiler = new Perl5Compiler();
    public String pattern;
    public int flags;
    public PyDictionary groupindex;
    private Pattern code;

    private static synchronized Pattern compile(String pattern, int flags) {
        try {
            return compiler.compile(pattern, flags);
        }
        catch (MalformedPatternException e) {
            throw re.ReError(e.getMessage());
        }
    }

    private static synchronized Perl5Matcher getMatcher() {
        Perl5Matcher matcher = new Perl5Matcher();
        return matcher;
    }

    public RegexObject(String pattern, int flags) {
        this.pattern = pattern;
        this.flags = flags;
        this.groupindex = new PyDictionary();
        this.code = RegexObject.compile(this.fixPattern(pattern), flags);
    }

    public MatchObject match(String string) {
        MatchResult result = this.doMatch(string);
        if (result == null) {
            return null;
        }
        return new MatchObject(this, string, 0, string.length(), result);
    }

    public MatchObject match(String s, int pos) {
        return this.match(s, pos, s.length());
    }

    public MatchObject match(String string, int pos, int endpos) {
        MatchResult result;
        if (endpos > string.length()) {
            endpos = string.length();
        }
        if (endpos < pos) {
            endpos = pos;
        }
        if ((result = this.doMatch(new PatternMatcherInput(string, pos, endpos - pos))) == null) {
            return null;
        }
        return new MatchObject(this, string, pos, endpos, result);
    }

    private MatchResult doMatch(Object input) {
        Perl5Matcher matcher = RegexObject.getMatcher();
        if (input instanceof String ? !matcher.matchesPrefix((String)input, this.code) : !matcher.matchesPrefix((PatternMatcherInput)input, this.code)) {
            return null;
        }
        return matcher.getMatch();
    }

    public MatchObject search(String string) {
        MatchResult result = this.doSearch(string);
        if (result == null) {
            return null;
        }
        return new MatchObject(this, string, 0, string.length(), result);
    }

    public MatchObject search(String s, int pos) {
        return this.search(s, pos, s.length());
    }

    public MatchObject search(String string, int pos, int endpos) {
        MatchResult result;
        if (endpos > string.length()) {
            endpos = string.length();
        }
        if (endpos < pos) {
            endpos = pos;
        }
        if ((result = this.doSearch(new PatternMatcherInput(string, pos, endpos - pos))) == null) {
            return null;
        }
        return new MatchObject(this, string, pos, endpos, result);
    }

    private MatchResult doSearch(Object input) {
        Perl5Matcher matcher = RegexObject.getMatcher();
        if (input instanceof String ? !matcher.contains((String)input, this.code) : !matcher.contains((PatternMatcherInput)input, this.code)) {
            return null;
        }
        return matcher.getMatch();
    }

    public PyString sub(PyObject repl, String string) {
        return this.sub(repl, string, 0);
    }

    public PyString sub(PyObject repl, String string, int count) {
        return (PyString)this.subn(repl, string, count).__getitem__(0);
    }

    public PyTuple subn(PyObject repl, String string) {
        return this.subn(repl, string, 0);
    }

    public PyTuple subn(PyObject repl, String string, int count) {
        String srepl = null;
        boolean expand = false;
        if (repl instanceof PyString) {
            srepl = repl.toString();
            boolean bl = expand = srepl.indexOf(92) != -1;
        }
        if (count < 0) {
            throw re.ReError("negative substitution count");
        }
        if (count == 0) {
            count = Integer.MAX_VALUE;
        }
        int n = 0;
        StringBuffer buf = new StringBuffer();
        Perl5Matcher matcher = RegexObject.getMatcher();
        PatternMatcherInput match = new PatternMatcherInput(string);
        int lastmatch = 0;
        while (n < count && !match.endOfInput() && matcher.contains(match, this.code)) {
            ++n;
            int offset = match.getMatchBeginOffset();
            if (offset > lastmatch) {
                buf.append(match.substring(lastmatch, offset));
            }
            if (srepl == null) {
                MatchObject m = new MatchObject(this, string, lastmatch, string.length(), matcher.getMatch());
                PyObject ret = repl.__call__(m);
                buf.append(ret.toString());
            } else if (expand) {
                buf.append(this.expandMatch(matcher.getMatch(), srepl));
            } else {
                buf.append(srepl);
            }
            lastmatch = match.getMatchEndOffset();
        }
        if (lastmatch < match.getEndOffset()) {
            buf.append(match.substring(lastmatch, match.getEndOffset()));
        }
        return new PyTuple(new PyObject[]{new PyString(buf.toString()), new PyInteger(n)});
    }

    public PyList split(String string) {
        return this.split(string, 0);
    }

    public PyList split(String string, int maxsplit) {
        if (maxsplit < 0) {
            throw re.ReError("maxsplit < 0");
        }
        if (maxsplit == 0) {
            maxsplit = Integer.MAX_VALUE;
        }
        int n = 0;
        Perl5Matcher matcher = RegexObject.getMatcher();
        PatternMatcherInput match = new PatternMatcherInput(string);
        int lastmatch = 0;
        PyList results = new PyList();
        while (n < maxsplit && !match.endOfInput() && matcher.contains(match, this.code)) {
            int end;
            ++n;
            int begin = match.getMatchBeginOffset();
            if (begin == (end = match.getMatchEndOffset())) continue;
            results.append(new PyString(match.substring(lastmatch, begin)));
            MatchResult m = matcher.getMatch();
            int ngroups = m.groups();
            if (ngroups > 1) {
                for (int j = 1; j < ngroups; ++j) {
                    String tmp = m.group(j);
                    if (tmp == null) {
                        results.append(Py.None);
                        continue;
                    }
                    results.append(new PyString(tmp));
                }
            }
            lastmatch = end;
        }
        results.append(new PyString(match.substring(lastmatch, match.getEndOffset())));
        return results;
    }

    private int getindex(PyString s) {
        PyInteger v = (PyInteger)this.groupindex.__finditem__(s);
        if (v == null) {
            try {
                v = (PyInteger)s.__int__();
            }
            catch (PyException exc) {
                if (!this.isname(s.toString())) {
                    throw re.ReError("illegal character in group name");
                }
                throw Py.IndexError("group " + s.__repr__() + " is undefined");
            }
        }
        return v.getValue();
    }

    private boolean isdigit(char c) {
        return '0' <= c && c <= '9';
    }

    private boolean isident(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '_';
    }

    private boolean isname(String name) {
        int n = name.length();
        if (n <= 0 || !this.isident(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            char c = name.charAt(i);
            if (this.isident(c) || this.isdigit(c)) continue;
            return false;
        }
        return true;
    }

    private String fixPattern(String pattern) {
        char[] chars = pattern.toCharArray();
        int index = 0;
        int group = 1;
        int lasti = 0;
        int n = chars.length;
        StringBuffer buf = new StringBuffer();
        while (index < n) {
            if (chars[index++] != '(' || index > 2 && chars[index - 2] == '\\') continue;
            if (index < n && chars[index] == '?') {
                if (++index < n && chars[index] == 'P') {
                    String name;
                    if (++index == n) break;
                    char c = chars[index++];
                    int start = index;
                    if (c == '<') {
                        while (index < n && chars[index] != '>') {
                            ++index;
                        }
                        if (index == n) {
                            throw re.ReError("unmatched <");
                        }
                        name = new String(chars, start, index - start);
                        if (!this.isname(name)) {
                            throw re.ReError("illegal character in group name");
                        }
                        this.groupindex.__setitem__(new PyString(name), (PyObject)new PyInteger(group));
                        buf.append(chars, lasti, start - 3 - lasti);
                        lasti = ++index;
                        ++group;
                        continue;
                    }
                    if (c == '=') {
                        while (index < n && chars[index] != ')') {
                            c = chars[index];
                            if (Character.isJavaIdentifierPart(c) && c != '$') {
                                ++index;
                                continue;
                            }
                            throw re.ReError("illegal character in symbol");
                        }
                        if (index == n) {
                            throw re.ReError("?P= not closed");
                        }
                        if (!Character.isJavaIdentifierStart(chars[start])) {
                            throw re.ReError("illegal character starting symbol");
                        }
                        name = new String(chars, start, index - start);
                        PyString pname = new PyString(name);
                        buf.append(chars, lasti, start - 4 - lasti);
                        buf.append('\\');
                        buf.append(this.getindex(pname));
                        lasti = ++index;
                        continue;
                    }
                    throw re.ReError("invalid ?P grouping");
                }
                if (chars[index] == ':') continue;
                while (index < n && chars[index] != ')') {
                    ++index;
                }
                continue;
            }
            ++group;
        }
        if (lasti > 0) {
            buf.append(chars, lasti, n - lasti);
            return buf.toString();
        }
        return pattern;
    }

    public String expandMatch(MatchResult match, String repl) {
        char[] chars = repl.toCharArray();
        int index = 0;
        int lasti = 0;
        int n = chars.length;
        StringBuffer buf = new StringBuffer();
        try {
            block15: while (index < n) {
                if (chars[index++] != '\\') continue;
                char ch = '\u0000';
                switch (chars[index++]) {
                    case '\\': {
                        ch = '\\';
                        break;
                    }
                    case 'E': 
                    case 'G': 
                    case 'L': 
                    case 'Q': 
                    case 'U': 
                    case 'l': 
                    case 'u': {
                        throw re.ReError("\\" + chars[index - 1] + " is not allowed");
                    }
                    case 'n': {
                        ch = '\n';
                        break;
                    }
                    case 't': {
                        ch = '\t';
                        break;
                    }
                    case 'r': {
                        ch = '\r';
                        break;
                    }
                    case 'v': {
                        ch = '\u000b';
                        break;
                    }
                    case 'f': {
                        ch = '\f';
                        break;
                    }
                    case 'a': {
                        ch = '\u0007';
                        break;
                    }
                    case 'b': {
                        ch = '\b';
                        break;
                    }
                    case 'g': {
                        if (chars[index++] != '<') {
                            throw re.ReError("missing < in symbolic reference");
                        }
                        int start = index;
                        while (index < n && chars[index] != '>') {
                            ++index;
                        }
                        if (index == n) {
                            throw re.ReError("unfinished symbolic reference");
                        }
                        buf.append(chars, lasti, start - 3 - lasti);
                        PyString str = new PyString(new String(chars, start, ++index - 1 - start));
                        String tmp = match.group(this.getindex(str));
                        if (tmp == null) {
                            throw re.ReError("group not in match: " + str);
                        }
                        buf.append(tmp);
                        lasti = index;
                        continue block15;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int start = index - 2;
                        int v = chars[index - 1] - 48;
                        if (index < n && (ch = chars[index]) >= '0' && ch <= '9') {
                            char ch1;
                            if (++index < n && ch <= '7' && (ch1 = chars[index]) >= '0' && ch1 <= '7') {
                                v = v * 64 + (ch - 48) * 8 + (ch1 - 48);
                                buf.append(chars, lasti, index - 2 - lasti);
                                buf.append((char)v);
                                lasti = ++index;
                            }
                            v = v * 10 + (ch - 48);
                        }
                        buf.append(chars, lasti, start - lasti);
                        String tmp = match.group(v);
                        if (tmp == null) {
                            throw re.ReError("group not in match: " + v);
                        }
                        buf.append(tmp);
                        lasti = index;
                        continue block15;
                    }
                    default: {
                        continue block15;
                    }
                }
                buf.append(chars, lasti, index - 2 - lasti);
                buf.append(ch);
                lasti = index;
            }
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw re.ReError("invalid expression");
        }
        if (lasti > 0) {
            buf.append(chars, lasti, n - lasti);
            return buf.toString();
        }
        return repl;
    }

    public PyList findall(String string) {
        Perl5Matcher matcher = RegexObject.getMatcher();
        PatternMatcherInput match = new PatternMatcherInput(string);
        PyList ret = new PyList();
        while (matcher.contains(match, this.code)) {
            MatchResult result = matcher.getMatch();
            int groups = result.groups();
            if (groups == 1) {
                ret.append(new PyString(result.group(0)));
                continue;
            }
            if (groups == 2) {
                ret.append(new PyString(result.group(1)));
                continue;
            }
            PyObject[] submatches = new PyString[groups - 1];
            for (int g = 1; g < groups; ++g) {
                submatches[g - 1] = new PyString(result.group(g));
            }
            PyTuple tup = new PyTuple(submatches);
            ret.append(tup);
        }
        return ret;
    }
}

