/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.BagOfTokens;
import com.wcohen.secondstring.Levenstein;
import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.tokens.SimpleTokenizer;
import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.Iterator;

public class Level2
extends AbstractStringDistance {
    private Tokenizer tokenizer;
    private StringDistance tokenDistance;

    public Level2(Tokenizer tokenizer, StringDistance tokenDistance) {
        this.tokenizer = tokenizer;
        this.tokenDistance = tokenDistance;
    }

    public double score(StringWrapper s, StringWrapper t) {
        BagOfTokens sBag = (BagOfTokens)s;
        BagOfTokens tBag = (BagOfTokens)t;
        double sumOverI = 0.0;
        Iterator i = sBag.tokenIterator();
        while (i.hasNext()) {
            Token tokenI = (Token)i.next();
            double maxOverJ = -1.7976931348623157E308;
            Iterator j = tBag.tokenIterator();
            while (j.hasNext()) {
                Token tokenJ = (Token)j.next();
                double scoreItoJ = this.tokenDistance.score(tokenI.getValue(), tokenJ.getValue());
                maxOverJ = Math.max(maxOverJ, scoreItoJ);
            }
            sumOverI += maxOverJ;
        }
        return sumOverI / (double)sBag.size();
    }

    public StringWrapper prepare(String s) {
        return new BagOfTokens(s, this.tokenizer.tokenize(s));
    }

    public String explainScore(StringWrapper s, StringWrapper t) {
        StringBuffer buf = new StringBuffer();
        BagOfTokens sBag = (BagOfTokens)s;
        BagOfTokens tBag = (BagOfTokens)t;
        double sumOverI = 0.0;
        Iterator i = sBag.tokenIterator();
        while (i.hasNext()) {
            Token tokenI = (Token)i.next();
            buf.append("token=" + tokenI);
            double maxOverJ = -1.7976931348623157E308;
            Token closestToI = null;
            Iterator j = tBag.tokenIterator();
            while (j.hasNext()) {
                Token tokenJ = (Token)j.next();
                double scoreItoJ = this.tokenDistance.score(tokenI.getValue(), tokenJ.getValue());
                buf.append(" dist(" + tokenJ.getValue() + ")=" + scoreItoJ);
                if (!(scoreItoJ >= maxOverJ)) continue;
                maxOverJ = scoreItoJ;
                closestToI = tokenJ;
            }
            sumOverI += maxOverJ;
            buf.append(" match=" + closestToI + " score=" + maxOverJ + "\n");
        }
        buf.append("total: " + sumOverI + "/" + sBag.size() + " = " + this.score(s, t) + "\n");
        return buf.toString();
    }

    public String toString() {
        return "[Level2:tokenizer=" + this.tokenizer + ";tokenDist=" + this.tokenDistance + "]";
    }

    public static void main(String[] argv) {
        Level2.doMain(new Level2(SimpleTokenizer.DEFAULT_TOKENIZER, new Levenstein()), argv);
    }
}

