/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring.expt;

import com.wcohen.secondstring.expt.MatchData;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public abstract class Blocker {
    protected boolean clusterMode;

    public abstract void block(MatchData var1);

    public abstract Pair getPair(int var1);

    public abstract int size();

    public final void setClusterMode(boolean flag) {
        this.clusterMode = flag;
    }

    public final void setClusterMode(Boolean flag) {
        this.clusterMode = flag;
    }

    public abstract int numCorrectPairs();

    protected int countCorrectPairs(MatchData data) {
        HashMap<IdKey, Integer> counter = new HashMap<IdKey, Integer>();
        for (int i = 0; i < data.numSources(); ++i) {
            String src = data.getSource(i);
            for (int j = 0; j < data.numInstances(src); ++j) {
                IdKey key;
                String id = data.getInstance(src, j).getId();
                if (id == null) continue;
                Integer c = (Integer)counter.get(key = new IdKey(id, src));
                counter.put(key, c == null ? new Integer(1) : new Integer(c + 1));
            }
        }
        int numCorrectPairs = 0;
        HashSet<String> idsInSrc1 = new HashSet<String>();
        for (int i = 0; i < data.numSources(); ++i) {
            String id;
            String src1 = data.getSource(i);
            idsInSrc1.clear();
            for (int j = 0; j < data.numInstances(src1); ++j) {
                id = data.getInstance(src1, j).getId();
                idsInSrc1.add(id);
                for (int k = i + 1; k < data.numSources(); ++k) {
                    String src2 = data.getSource(k);
                    Integer cInteger = (Integer)counter.get(new IdKey(id, src2));
                    if (cInteger == null) continue;
                    numCorrectPairs += cInteger.intValue();
                }
            }
            if (!this.clusterMode) continue;
            Iterator j = idsInSrc1.iterator();
            while (j.hasNext()) {
                id = (String)j.next();
                Integer cInteger = (Integer)counter.get(new IdKey(id, src1));
                int c = cInteger;
                numCorrectPairs += c * (c - 1) / 2;
            }
        }
        return numCorrectPairs;
    }

    private static class IdKey {
        public String id;
        public String src;

        public IdKey(String id, String src) {
            this.id = id;
            this.src = src;
        }

        public int hashCode() {
            return this.id.hashCode() ^ this.src.hashCode();
        }

        public boolean equals(Object o) {
            IdKey key = (IdKey)o;
            return key.id.equals(this.id) && key.src.equals(this.src);
        }
    }

    public static class Pair
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static int CURRENT_SERIALIZED_VERSION_NUMBER = 1;
        private final transient MatchData.Instance a;
        private final transient MatchData.Instance b;
        private boolean sameIds;
        private double distance = -9999.0;

        public Pair(MatchData.Instance a, MatchData.Instance b) {
            this.a = a;
            this.b = b;
            this.sameIds = a.getId() != null && a.getId().equals(b.getId());
        }

        public MatchData.Instance getA() {
            return this.a;
        }

        public MatchData.Instance getB() {
            return this.b;
        }

        public boolean isCorrect() {
            return this.sameIds;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double d) {
            this.distance = d;
        }

        public int compareTo(Object o) {
            Pair other = (Pair)o;
            if (other.distance > this.distance) {
                return 1;
            }
            if (other.distance < this.distance) {
                return -1;
            }
            return 0;
        }
    }
}

