/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.constraints;

import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.util.ArrayList;
import java.util.BitSet;

public class SelfTransitionGEConstraint
implements GEConstraint {
    private double selfTransProb;
    private double numTokens;
    private double expectation;
    private double weight;

    public SelfTransitionGEConstraint(double selfTransProb, double weight) {
        this.selfTransProb = selfTransProb;
        this.weight = weight;
        this.numTokens = 0.0;
        this.expectation = 0.0;
    }

    private SelfTransitionGEConstraint(double selfTransProb, double weight, double numTokens, double expectation) {
        this.selfTransProb = selfTransProb;
        this.weight = weight;
        this.numTokens = numTokens;
        this.expectation = expectation;
    }

    @Override
    public GEConstraint copy() {
        return new SelfTransitionGEConstraint(this.selfTransProb, this.weight, this.numTokens, this.expectation);
    }

    @Override
    public boolean isOneStateConstraint() {
        return false;
    }

    @Override
    public void setStateLabelMap(StateLabelMap map) {
    }

    @Override
    public void preProcess(FeatureVector fv) {
    }

    @Override
    public BitSet preProcess(InstanceList data) {
        BitSet bitSet = new BitSet(data.size());
        bitSet.set(0, data.size(), true);
        for (Instance instance : data) {
            FeatureVectorSequence fvs = (FeatureVectorSequence)instance.getData();
            this.numTokens += (double)fvs.size();
        }
        return bitSet;
    }

    @Override
    public double getConstraintFeatureValue(FeatureVector fv, int ip, int si1, int si2) {
        if (si1 == si2) {
            return this.weight * (this.selfTransProb / this.expectation);
        }
        return this.weight * ((1.0 - this.selfTransProb) / (this.numTokens - this.expectation));
    }

    @Override
    public double getValue() {
        double selfTransEx = this.expectation / this.numTokens;
        if (this.selfTransProb == 1.0) {
            return this.weight * Math.log(selfTransEx);
        }
        if (this.selfTransProb == 0.0) {
            return this.weight * Math.log(1.0 - selfTransEx);
        }
        return this.weight * (this.selfTransProb * (Math.log(selfTransEx) - Math.log(this.selfTransProb)) + (1.0 - this.selfTransProb) * (Math.log(1.0 - selfTransEx) - Math.log(1.0 - this.selfTransProb)));
    }

    @Override
    public void zeroExpectations() {
        this.expectation = 0.0;
    }

    @Override
    public void computeExpectations(ArrayList<SumLatticeDefault> lattices) {
        for (int i = 0; i < lattices.size(); ++i) {
            SumLatticeDefault lattice = lattices.get(i);
            double[][][] xis = lattice.getXis();
            int numStates = xis[0].length;
            FeatureVectorSequence fvs = (FeatureVectorSequence)lattice.getInput();
            for (int ip = 0; ip < fvs.size(); ++ip) {
                for (int si = 0; si < numStates; ++si) {
                    this.expectation += Math.exp(xis[ip][si][si]);
                }
            }
        }
        System.err.println("Self transition expectation: " + this.expectation / this.numTokens);
    }
}

