/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference.gbp;

import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.Variable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class Region {
    Set factors;
    List parents;
    List children = new ArrayList(0);
    List vars;
    int index = -1;
    boolean isRoot = true;
    int countingNumber;
    Set descendants;

    private Region() {
        this.parents = new ArrayList(0);
    }

    Region(Variable var) {
        this();
        this.factors = new THashSet();
        this.vars = new ArrayList(1);
        this.vars.add(var);
    }

    Region(Factor ptl) {
        this();
        this.factors = new THashSet();
        this.factors.add(ptl);
        this.vars = new ArrayList(ptl.varSet());
    }

    Region(Variable[] vars, Factor[] factors) {
        this();
        this.factors = new THashSet(Arrays.asList(factors));
        this.vars = new ArrayList<Variable>(Arrays.asList(vars));
    }

    Region(Collection vars, Collection factors) {
        this();
        this.factors = new THashSet(factors);
        this.vars = new ArrayList(vars);
    }

    Region(Collection vars) {
        this();
        this.vars = new ArrayList(vars);
        this.factors = new THashSet();
    }

    void addFactor(Factor ptl) {
        if (!this.factors.contains(ptl)) {
            this.factors.add(ptl);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("REGION[");
        Iterator it = this.vars.iterator();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            buf.append(var);
            if (!it.hasNext()) continue;
            buf.append(" ");
        }
        buf.append("] nf:");
        buf.append(this.factors.size());
        return buf.toString();
    }
}

