/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.SparseVector;
import gnu.trove.TIntHashSet;
import java.util.Arrays;
import java.util.Iterator;

public class VectorStats {
    public static SparseVector mean(InstanceList instances) {
        if (instances == null || instances.size() == 0) {
            return null;
        }
        Iterator instanceItr = instances.iterator();
        int maxSparseIndex = -1;
        int maxDenseIndex = -1;
        TIntHashSet hIndices = new TIntHashSet(instances.getDataAlphabet().size());
        while (instanceItr.hasNext()) {
            Instance instance = (Instance)instanceItr.next();
            SparseVector v = (SparseVector)instance.getData();
            int[] indices = v.getIndices();
            if (indices != null) {
                hIndices.addAll(indices);
                if (indices[indices.length - 1] <= maxSparseIndex) continue;
                maxSparseIndex = indices[indices.length - 1];
                continue;
            }
            if (v.numLocations() <= maxDenseIndex) continue;
            maxDenseIndex = v.numLocations() - 1;
        }
        if (maxDenseIndex > -1) {
            if (maxSparseIndex > maxDenseIndex) {
                for (int i = 0; i <= maxDenseIndex; ++i) {
                    hIndices.add(i);
                }
            } else {
                return VectorStats.mean(instances, maxDenseIndex + 1);
            }
        }
        return VectorStats.mean(instances, hIndices.toArray());
    }

    public static SparseVector mean(InstanceList instances, int numIndices) {
        SparseVector mv = new SparseVector(new double[numIndices], false);
        return VectorStats.mean(instances, mv);
    }

    public static SparseVector mean(InstanceList instances, int[] indices) {
        Arrays.sort(indices);
        SparseVector mv = new SparseVector(indices, new double[indices.length], false, false, false);
        return VectorStats.mean(instances, mv);
    }

    private static SparseVector mean(InstanceList instances, SparseVector meanVector) {
        if (instances == null || instances.size() == 0) {
            return null;
        }
        Iterator instanceItr = instances.iterator();
        double factor = 1.0 / (double)instances.size();
        while (instanceItr.hasNext()) {
            Instance instance = (Instance)instanceItr.next();
            SparseVector v = (SparseVector)instance.getData();
            meanVector.plusEqualsSparse(v, factor);
        }
        return meanVector;
    }

    public static SparseVector variance(InstanceList instances, boolean unbiased) {
        return VectorStats.variance(instances, VectorStats.mean(instances), unbiased);
    }

    public static SparseVector variance(InstanceList instances, SparseVector mean, boolean unbiased) {
        if (instances == null || instances.size() == 0) {
            return null;
        }
        double factor = 1.0 / ((double)instances.size() - (unbiased ? 1.0 : 0.0));
        System.out.println("factor = " + factor);
        SparseVector vv = (SparseVector)mean.cloneMatrix();
        vv.timesEqualsSparse(vv, -((double)instances.size()) * factor);
        for (Instance instance : instances) {
            SparseVector v = (SparseVector)((SparseVector)instance.getData()).cloneMatrix();
            v.timesEqualsSparse(v);
            vv.plusEqualsSparse(v, factor);
        }
        System.out.println("Var:\n" + vv);
        return vv;
    }

    public static SparseVector variance(InstanceList instances) {
        return VectorStats.variance(instances, true);
    }

    public static SparseVector variance(InstanceList instances, SparseVector mean) {
        return VectorStats.variance(instances, mean, true);
    }

    public static SparseVector stddev(InstanceList instances, SparseVector mean, boolean unbiased) {
        if (instances.size() == 0) {
            return null;
        }
        SparseVector sv = VectorStats.variance(instances, mean, unbiased);
        int dim = sv.numLocations();
        for (int i = 0; i < dim; ++i) {
            double val = sv.valueAtLocation(i);
            sv.setValueAtLocation(i, Math.sqrt(val));
        }
        return sv;
    }

    public static SparseVector stddev(InstanceList instances) {
        return VectorStats.stddev(instances, true);
    }

    public static SparseVector stddev(InstanceList instances, boolean unbiased) {
        return VectorStats.stddev(instances, VectorStats.mean(instances), unbiased);
    }

    public static SparseVector stddev(InstanceList instances, SparseVector mean) {
        return VectorStats.stddev(instances, mean, true);
    }
}

