/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Boostable;
import cc.mallet.classify.ClassifierTrainer;
import cc.mallet.classify.FeatureConstraintUtil;
import cc.mallet.classify.MaxEnt;
import cc.mallet.classify.MaxEntOptimizableByGE;
import cc.mallet.classify.MaxEntOptimizableByKLGE;
import cc.mallet.classify.MaxEntOptimizableByL2GE;
import cc.mallet.optimize.LimitedMemoryBFGS;
import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.Optimizer;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.MalletProgressMessageLogger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Logger;

public class MaxEntGETrainer
extends ClassifierTrainer<MaxEnt>
implements ClassifierTrainer.ByOptimization<MaxEnt>,
Boostable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = MalletLogger.getLogger(MaxEntGETrainer.class.getName());
    private static Logger progressLogger = MalletProgressMessageLogger.getLogger(MaxEntGETrainer.class.getName() + "-pl");
    private boolean l2 = false;
    private boolean normalize = true;
    private boolean useValues = false;
    private int numIterations = Integer.MAX_VALUE;
    private double temperature = 1.0;
    private double gaussianPriorVariance = 1.0;
    private String constraintsFile;
    private HashMap<Integer, double[]> constraints;
    private InstanceList trainingList = null;
    private MaxEnt classifier = null;
    private MaxEntOptimizableByGE ge = null;
    private Optimizer opt = null;

    public MaxEntGETrainer() {
    }

    public MaxEntGETrainer(HashMap<Integer, double[]> constraints) {
        this.constraints = constraints;
    }

    public MaxEntGETrainer(HashMap<Integer, double[]> constraints, MaxEnt classifier) {
        this.constraints = constraints;
        this.classifier = classifier;
    }

    public void setUseValues(boolean flag) {
        this.useValues = flag;
    }

    public void setL2(boolean flag) {
        this.l2 = flag;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setConstraintsFile(String filename) {
        this.constraintsFile = filename;
    }

    public void setTemperature(double temp) {
        this.temperature = temp;
    }

    public void setGaussianPriorVariance(double variance) {
        this.gaussianPriorVariance = variance;
    }

    @Override
    public MaxEnt getClassifier() {
        return this.classifier;
    }

    public Optimizable getOptimizable() {
        return this.ge;
    }

    @Override
    public Optimizer getOptimizer() {
        return this.opt;
    }

    public void setNumIterations(int i) {
        this.numIterations = i;
    }

    @Override
    public int getIteration() {
        if (this.ge == null) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public MaxEnt train(InstanceList trainingList) {
        return this.train(trainingList, this.numIterations);
    }

    @Override
    public MaxEnt train(InstanceList train, int numIterations) {
        this.trainingList = train;
        if (this.constraints == null && this.constraintsFile != null) {
            this.constraints = FeatureConstraintUtil.readConstraintsFromFile(this.constraintsFile, this.trainingList);
            logger.info("number of constraints: " + this.constraints.size());
        }
        this.ge = this.l2 ? new MaxEntOptimizableByL2GE(this.trainingList, this.constraints, this.classifier, this.normalize) : new MaxEntOptimizableByKLGE(this.trainingList, this.constraints, this.classifier);
        this.ge.setTemperature(this.temperature);
        this.ge.setGaussianPriorVariance(this.gaussianPriorVariance);
        this.ge.setUseValues(this.useValues);
        this.opt = new LimitedMemoryBFGS(this.ge);
        logger.fine("trainingList.size() = " + this.trainingList.size());
        for (int i = 0; i < numIterations; ++i) {
            boolean converged;
            try {
                converged = this.opt.optimize(1);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("Catching exception; saying converged.");
                converged = true;
            }
            if (converged) break;
        }
        if (numIterations == Integer.MAX_VALUE) {
            this.opt = new LimitedMemoryBFGS(this.ge);
            try {
                this.opt.optimize();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("Catching exception; saying converged.");
            }
        }
        progressLogger.info("\n");
        this.classifier = this.ge.getClassifier();
        return this.classifier;
    }
}

