/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.SumLattice;
import cc.mallet.fst.SumLatticeFactory;
import cc.mallet.fst.Transducer;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelVector;
import cc.mallet.types.MatrixOps;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SumLatticeDefault
implements SumLattice {
    private static Logger logger = MalletLogger.getLogger(SumLatticeDefault.class.getName());
    protected static boolean saveXis = false;
    Transducer t;
    double totalWeight;
    Sequence input;
    Sequence output;
    LatticeNode[][] nodes;
    int latticeLength;
    double[][] gammas;
    double[][][] xis;
    LabelVector[] labelings;

    protected SumLatticeDefault() {
    }

    protected LatticeNode getLatticeNode(int ip, int stateIndex) {
        if (this.nodes[ip][stateIndex] == null) {
            this.nodes[ip][stateIndex] = new LatticeNode(ip, this.t.getState(stateIndex));
        }
        return this.nodes[ip][stateIndex];
    }

    public SumLatticeDefault(Transducer trans, Sequence input) {
        this(trans, input, null, null, saveXis, null);
    }

    public SumLatticeDefault(Transducer trans, Sequence input, boolean saveXis) {
        this(trans, input, null, null, saveXis, null);
    }

    public SumLatticeDefault(Transducer trans, Sequence input, Transducer.Incrementor incrementor) {
        this(trans, input, null, incrementor, saveXis, null);
    }

    public SumLatticeDefault(Transducer trans, Sequence input, Sequence output) {
        this(trans, input, output, null, saveXis, null);
    }

    public SumLatticeDefault(Transducer trans, Sequence input, Sequence output, Transducer.Incrementor incrementor) {
        this(trans, input, output, incrementor, saveXis, null);
    }

    public SumLatticeDefault(Transducer trans, Sequence input, Sequence output, Transducer.Incrementor incrementor, LabelAlphabet outputAlphabet) {
        this(trans, input, output, incrementor, saveXis, outputAlphabet);
    }

    public SumLatticeDefault(Transducer trans, Sequence input, Sequence output, Transducer.Incrementor incrementor, boolean saveXis) {
        this(trans, input, output, incrementor, saveXis, null);
    }

    public SumLatticeDefault(Transducer trans, Sequence input, Sequence output, Transducer.Incrementor incrementor, boolean saveXis, LabelAlphabet outputAlphabet) {
        Transducer.State destination;
        Transducer.TransitionIterator iter;
        int i;
        int ip;
        assert (output == null || input.size() == output.size());
        this.t = trans;
        this.input = input;
        this.output = output;
        this.latticeLength = input.size() + 1;
        int numStates = this.t.numStates();
        this.nodes = new LatticeNode[this.latticeLength][numStates];
        this.gammas = new double[this.latticeLength][numStates];
        if (saveXis) {
            this.xis = new double[this.latticeLength][numStates][numStates];
        }
        double[][] outputCounts = null;
        if (outputAlphabet != null) {
            outputCounts = new double[this.latticeLength][outputAlphabet.size()];
        }
        for (int i2 = 0; i2 < numStates; ++i2) {
            for (ip = 0; ip < this.latticeLength; ++ip) {
                this.gammas[ip][i2] = Double.NEGATIVE_INFINITY;
            }
            if (!saveXis) continue;
            for (int j = 0; j < numStates; ++j) {
                for (int ip2 = 0; ip2 < this.latticeLength; ++ip2) {
                    this.xis[ip2][i2][j] = Double.NEGATIVE_INFINITY;
                }
            }
        }
        logger.fine("Starting Foward pass");
        boolean atLeastOneInitialState = false;
        for (i = 0; i < numStates; ++i) {
            double initialWeight = this.t.getState(i).getInitialWeight();
            if (!(initialWeight > Double.NEGATIVE_INFINITY)) continue;
            this.getLatticeNode((int)0, (int)i).alpha = initialWeight;
            atLeastOneInitialState = true;
        }
        if (!atLeastOneInitialState) {
            logger.warning("There are no starting states!");
        }
        for (ip = 0; ip < this.latticeLength - 1; ++ip) {
            for (int i3 = 0; i3 < numStates; ++i3) {
                if (this.nodes[ip][i3] == null || this.nodes[ip][i3].alpha == Double.NEGATIVE_INFINITY) continue;
                Transducer.State s = this.t.getState(i3);
                iter = s.transitionIterator(input, ip, output, ip);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" Starting Foward transition iteration from state " + s.getName() + " on input " + input.get(ip).toString() + " and output " + (output == null ? "(null)" : output.get(ip).toString()));
                }
                while (iter.hasNext()) {
                    destination = iter.nextState();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Forward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                    }
                    LatticeNode destinationNode = this.getLatticeNode(ip + 1, destination.getIndex());
                    destinationNode.output = iter.getOutput();
                    double transitionWeight = iter.getWeight();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("BEFORE update: destinationNode.alpha=" + destinationNode.alpha);
                    }
                    destinationNode.alpha = Transducer.sumLogProb(destinationNode.alpha, this.nodes[ip][i3].alpha + transitionWeight);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("transitionWeight=" + transitionWeight + " nodes[" + ip + "][" + i3 + "].alpha=" + this.nodes[ip][i3].alpha + " destinationNode.alpha=" + destinationNode.alpha);
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Forward Lattice:");
            for (ip = 0; ip < this.latticeLength; ++ip) {
                StringBuffer sb = new StringBuffer();
                for (int i4 = 0; i4 < numStates; ++i4) {
                    sb.append(" " + (this.nodes[ip][i4] == null ? "<null>" : Double.valueOf(this.nodes[ip][i4].alpha)));
                }
                logger.fine(sb.toString());
            }
        }
        this.totalWeight = Double.NEGATIVE_INFINITY;
        for (i = 0; i < numStates; ++i) {
            if (this.nodes[this.latticeLength - 1][i] == null) continue;
            this.totalWeight = Transducer.sumLogProb(this.totalWeight, this.nodes[this.latticeLength - 1][i].alpha + this.t.getState(i).getFinalWeight());
        }
        logger.fine("totalWeight=" + this.totalWeight);
        if (this.totalWeight == Double.NEGATIVE_INFINITY) {
            return;
        }
        for (i = 0; i < numStates; ++i) {
            if (this.nodes[this.latticeLength - 1][i] == null) continue;
            Transducer.State s = this.t.getState(i);
            this.nodes[this.latticeLength - 1][i].beta = s.getFinalWeight();
            this.gammas[this.latticeLength - 1][i] = this.nodes[this.latticeLength - 1][i].alpha + this.nodes[this.latticeLength - 1][i].beta - this.totalWeight;
            if (incrementor == null) continue;
            double p = Math.exp(this.gammas[this.latticeLength - 1][i]);
            assert (p >= 0.0 && p <= 1.000001) : "p=" + p + ", gamma=" + this.gammas[this.latticeLength - 1][i];
            incrementor.incrementFinalState(s, p);
        }
        for (ip = this.latticeLength - 2; ip >= 0; --ip) {
            for (int i5 = 0; i5 < numStates; ++i5) {
                if (this.nodes[ip][i5] == null || this.nodes[ip][i5].alpha == Double.NEGATIVE_INFINITY) continue;
                Transducer.State s = this.t.getState(i5);
                iter = s.transitionIterator(input, ip, output, ip);
                while (iter.hasNext()) {
                    int j;
                    LatticeNode destinationNode;
                    destination = iter.nextState();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Backward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                    }
                    if ((destinationNode = this.nodes[ip + 1][j = destination.getIndex()]) == null) continue;
                    double transitionWeight = iter.getWeight();
                    assert (!Double.isNaN(transitionWeight));
                    double oldBeta = this.nodes[ip][i5].beta;
                    assert (!Double.isNaN(this.nodes[ip][i5].beta));
                    this.nodes[ip][i5].beta = Transducer.sumLogProb(this.nodes[ip][i5].beta, destinationNode.beta + transitionWeight);
                    assert (!Double.isNaN(this.nodes[ip][i5].beta)) : "dest.beta=" + destinationNode.beta + " trans=" + transitionWeight + " sum=" + (destinationNode.beta + transitionWeight) + " oldBeta=" + oldBeta;
                    double xi = this.nodes[ip][i5].alpha + transitionWeight + this.nodes[ip + 1][j].beta - this.totalWeight;
                    if (saveXis) {
                        this.xis[ip][i5][j] = xi;
                    }
                    assert (!Double.isNaN(this.nodes[ip][i5].alpha));
                    assert (!Double.isNaN(transitionWeight));
                    assert (!Double.isNaN(this.nodes[ip + 1][j].beta));
                    assert (!Double.isNaN(this.totalWeight));
                    if (incrementor == null && outputAlphabet == null) continue;
                    double p = Math.exp(xi);
                    assert (p >= 0.0 && p <= 1.000001) : "p=" + p + ", xis[" + ip + "][" + i5 + "][" + j + "]=" + xi;
                    if (incrementor != null) {
                        incrementor.incrementTransition(iter, p);
                    }
                    if (outputAlphabet == null) continue;
                    int outputIndex = outputAlphabet.lookupIndex(iter.getOutput(), false);
                    assert (outputIndex >= 0);
                    double[] dArray = outputCounts[ip];
                    int n = outputIndex;
                    dArray[n] = dArray[n] + p;
                }
                this.gammas[ip][i5] = this.nodes[ip][i5].alpha + this.nodes[ip][i5].beta - this.totalWeight;
            }
        }
        if (incrementor != null) {
            for (i = 0; i < numStates; ++i) {
                double p = Math.exp(this.gammas[0][i]);
                assert (p >= 0.0 && p <= 1.000001) : "p=" + p;
                incrementor.incrementInitialState(this.t.getState(i), p);
            }
        }
        if (outputAlphabet != null) {
            this.labelings = new LabelVector[this.latticeLength];
            for (ip = this.latticeLength - 2; ip >= 0; --ip) {
                assert (Math.abs(1.0 - MatrixOps.sum(outputCounts[ip])) < 1.0E-6);
                this.labelings[ip] = new LabelVector(outputAlphabet, outputCounts[ip]);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Lattice:");
            for (ip = 0; ip < this.latticeLength; ++ip) {
                StringBuffer sb = new StringBuffer();
                for (int i6 = 0; i6 < numStates; ++i6) {
                    sb.append(" " + this.gammas[ip][i6]);
                }
                logger.fine(sb.toString());
            }
        }
    }

    @Override
    public double[][][] getXis() {
        return this.xis;
    }

    @Override
    public double[][] getGammas() {
        return this.gammas;
    }

    @Override
    public double getTotalWeight() {
        assert (!Double.isNaN(this.totalWeight));
        return this.totalWeight;
    }

    @Override
    public double getGammaWeight(int inputPosition, Transducer.State s) {
        return this.gammas[inputPosition][s.getIndex()];
    }

    public double getGammaWeight(int inputPosition, int stateIndex) {
        return this.gammas[inputPosition][stateIndex];
    }

    @Override
    public double getGammaProbability(int inputPosition, Transducer.State s) {
        return Math.exp(this.gammas[inputPosition][s.getIndex()]);
    }

    public double getGammaProbability(int inputPosition, int stateIndex) {
        return Math.exp(this.gammas[inputPosition][stateIndex]);
    }

    @Override
    public double getXiProbability(int ip, Transducer.State s1, Transducer.State s2) {
        if (this.xis == null) {
            throw new IllegalStateException("xis were not saved.");
        }
        int i = s1.getIndex();
        int j = s2.getIndex();
        return Math.exp(this.xis[ip][i][j]);
    }

    @Override
    public double getXiWeight(int ip, Transducer.State s1, Transducer.State s2) {
        if (this.xis == null) {
            throw new IllegalStateException("xis were not saved.");
        }
        int i = s1.getIndex();
        int j = s2.getIndex();
        return this.xis[ip][i][j];
    }

    @Override
    public int length() {
        return this.latticeLength;
    }

    public Sequence getInput() {
        return this.input;
    }

    @Override
    public double getAlpha(int ip, Transducer.State s) {
        LatticeNode node = this.getLatticeNode(ip, s.getIndex());
        return node.alpha;
    }

    @Override
    public double getBeta(int ip, Transducer.State s) {
        LatticeNode node = this.getLatticeNode(ip, s.getIndex());
        return node.beta;
    }

    @Override
    public LabelVector getLabelingAtPosition(int outputPosition) {
        if (this.labelings != null) {
            return this.labelings[outputPosition];
        }
        return null;
    }

    @Override
    public Transducer getTransducer() {
        return this.t;
    }

    public static class Factory
    extends SumLatticeFactory
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 1;

        @Override
        public SumLattice newSumLattice(Transducer trans, Sequence input, Sequence output, Transducer.Incrementor incrementor, boolean saveXis, LabelAlphabet outputAlphabet) {
            return new SumLatticeDefault(trans, input, output, incrementor, saveXis, outputAlphabet);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(1);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
        }
    }

    protected class LatticeNode {
        int inputPosition;
        Transducer.State state;
        Object output;
        double alpha = Double.NEGATIVE_INFINITY;
        double beta = Double.NEGATIVE_INFINITY;

        LatticeNode(int inputPosition, Transducer.State state) {
            this.inputPosition = inputPosition;
            this.state = state;
            assert (this.alpha == Double.NEGATIVE_INFINITY);
        }
    }
}

