/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.regex.Pattern;

public class OffsetFeatureConjunction
extends Pipe
implements Serializable {
    private String thisFeatureName;
    private Pattern[] featurePatterns;
    private int[] offsets;
    private boolean[] isNonNegated;
    private boolean tagAllTimesteps;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;
    private static final int NULL_INTEGER = -1;

    public OffsetFeatureConjunction(String thisFeatureName, String[] featureNames, int[] offsets, boolean[] isNonNegated, boolean tagAllTimesteps) {
        this.thisFeatureName = thisFeatureName;
        this.featurePatterns = this.patternify(featureNames);
        this.offsets = offsets;
        this.isNonNegated = isNonNegated;
        this.tagAllTimesteps = tagAllTimesteps;
    }

    private static boolean[] trueArray(int length) {
        boolean[] ret = new boolean[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = true;
        }
        return ret;
    }

    private Pattern[] patternify(String[] regex) {
        Pattern[] retval = new Pattern[regex.length];
        for (int i = 0; i < regex.length; ++i) {
            retval[i] = Pattern.compile(regex[i]);
        }
        return retval;
    }

    public OffsetFeatureConjunction(String thisFeatureName, String[] featureNames, int[] offsets, boolean tagAllTimesteps) {
        this(thisFeatureName, featureNames, offsets, OffsetFeatureConjunction.trueArray(featureNames.length), tagAllTimesteps);
    }

    public OffsetFeatureConjunction(String thisFeatureName, String[] featureNames, int[] offsets) {
        this(thisFeatureName, featureNames, offsets, OffsetFeatureConjunction.trueArray(featureNames.length), false);
    }

    public boolean isTagAllTimesteps() {
        return this.tagAllTimesteps;
    }

    public String getFeatureName() {
        return this.thisFeatureName;
    }

    public Pattern[] getFeaturePatterns() {
        return this.featurePatterns;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public boolean[] getNonNegated() {
        return this.isNonNegated;
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        int tsSize = ts.size();
        for (int t = 0; t < tsSize; ++t) {
            int pos;
            int fnum;
            boolean passes = true;
            for (fnum = 0; fnum < this.featurePatterns.length; ++fnum) {
                pos = t + this.offsets[fnum];
                if (pos < 0 || pos >= tsSize) {
                    passes = false;
                    break;
                }
                boolean featurePresent = this.hasMatchingFeature((Token)ts.get(pos), this.featurePatterns[fnum]);
                if (featurePresent == this.isNonNegated[fnum]) continue;
                passes = false;
                break;
            }
            if (!passes) continue;
            if (this.tagAllTimesteps) {
                for (fnum = 0; fnum < this.featurePatterns.length; ++fnum) {
                    pos = t + this.offsets[fnum];
                    ((Token)ts.get(pos)).setFeatureValue(this.thisFeatureName, 1.0);
                }
                continue;
            }
            ((Token)ts.get(t)).setFeatureValue(this.thisFeatureName, 1.0);
        }
        return carrier;
    }

    private boolean hasMatchingFeature(Token token, Pattern pattern) {
        PropertyList.Iterator iter = token.getFeatures().iterator();
        while (iter.hasNext()) {
            iter.next();
            if (!pattern.matcher(iter.getKey()).matches() || iter.getNumericValue() != 1.0) continue;
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.thisFeatureName);
        out.writeBoolean(this.tagAllTimesteps);
        int size = this.featurePatterns == null ? -1 : this.featurePatterns.length;
        out.writeInt(size);
        if (size != -1) {
            for (int i = 0; i < size; ++i) {
                out.writeObject(this.featurePatterns[i]);
                out.writeInt(this.offsets[i]);
                out.writeBoolean(this.isNonNegated[i]);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size;
        int version = in.readInt();
        this.thisFeatureName = (String)in.readObject();
        if (version >= 1) {
            this.tagAllTimesteps = in.readBoolean();
        }
        if ((size = in.readInt()) == -1) {
            this.featurePatterns = null;
            this.offsets = null;
            this.isNonNegated = null;
        } else {
            this.featurePatterns = new Pattern[size];
            this.offsets = new int[size];
            this.isNonNegated = new boolean[size];
            for (int i = 0; i < size; ++i) {
                this.featurePatterns[i] = (Pattern)in.readObject();
                this.offsets[i] = in.readInt();
                this.isNonNegated[i] = in.readBoolean();
            }
        }
    }
}

