/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.ConstantMatrix;
import cc.mallet.types.DenseVector;
import cc.mallet.types.SparseVector;
import cc.mallet.util.MalletLogger;
import gnu.trove.TIntIntHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;

public class HashedSparseVector
extends SparseVector
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(SparseVector.class.getName());
    TIntIntHashMap index2location;
    int maxIndex;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;
    static final int NULL_INTEGER = -1;

    public HashedSparseVector(int[] indices, double[] values, int capacity, int size, boolean copy, boolean checkIndicesSorted, boolean removeDuplicates) {
        super(indices, values, capacity, size, copy, checkIndicesSorted, removeDuplicates);
        assert (indices != null);
    }

    public HashedSparseVector() {
        super(new int[0], new double[0], 0, 0, false, false, false);
    }

    public HashedSparseVector(int[] featureIndices, double[] values) {
        super(featureIndices, values);
    }

    public HashedSparseVector(int[] featureIndices) {
        super(featureIndices);
    }

    @Override
    public ConstantMatrix cloneMatrix() {
        return new HashedSparseVector(this.indices, this.values);
    }

    @Override
    public ConstantMatrix cloneMatrixZeroed() {
        assert (this.values != null);
        int[] newIndices = new int[this.indices.length];
        System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
        HashedSparseVector sv = new HashedSparseVector(newIndices, new double[this.values.length], this.values.length, this.values.length, false, false, false);
        if (this.index2location != null) {
            sv.index2location = this.index2location;
            sv.maxIndex = this.maxIndex;
        }
        return sv;
    }

    public void indexVector() {
        if (this.index2location == null && this.indices.length > 0) {
            this.setIndex2Location();
        }
    }

    private void setIndex2Location() {
        assert (this.index2location == null);
        assert (this.indices.length > 0);
        this.maxIndex = this.indices[this.indices.length - 1];
        this.index2location = new TIntIntHashMap(this.numLocations());
        for (int i = 0; i < this.indices.length; ++i) {
            this.index2location.put(this.indices[i], i);
        }
    }

    @Override
    public final void setValue(int index, double value) {
        if (this.index2location == null) {
            this.setIndex2Location();
        }
        int location = this.index2location.get(index);
        if (!this.index2location.contains(index)) {
            throw new IllegalArgumentException("Trying to set value that isn't present in HashedSparseVector");
        }
        this.values[location] = value;
    }

    @Override
    public final void setValueAtLocation(int location, double value) {
        this.values[location] = value;
    }

    public void columnPlusEquals(int index, double value) {
        if (this.index2location == null) {
            this.setIndex2Location();
        }
        int location = this.index2location.get(index);
        if (!this.index2location.contains(index)) {
            throw new IllegalArgumentException("Trying to set value that isn't present in HashedSparseVector");
        }
        int n = location;
        this.values[n] = this.values[n] + value;
    }

    @Override
    public final double dotProduct(DenseVector v) {
        double ret = 0.0;
        if (this.values == null) {
            for (int i = 0; i < this.indices.length; ++i) {
                ret += v.value(this.indices[i]);
            }
        } else {
            for (int i = 0; i < this.indices.length; ++i) {
                ret += this.values[i] * v.value(this.indices[i]);
            }
        }
        return ret;
    }

    @Override
    public final double dotProduct(SparseVector v) {
        if (this.indices.length == 0) {
            return 0.0;
        }
        if (this.index2location == null) {
            this.setIndex2Location();
        }
        double ret = 0.0;
        int vNumLocs = v.numLocations();
        if (this.values == null) {
            int index;
            for (int i = 0; i < vNumLocs && (index = v.indexAtLocation(i)) <= this.maxIndex; ++i) {
                if (!this.index2location.contains(index)) continue;
                ret += v.valueAtLocation(i);
            }
        } else {
            int index;
            for (int i = 0; i < vNumLocs && (index = v.indexAtLocation(i)) <= this.maxIndex; ++i) {
                if (!this.index2location.containsKey(index)) continue;
                ret += this.values[this.index2location.get(index)] * v.valueAtLocation(i);
            }
        }
        return ret;
    }

    @Override
    public final void plusEqualsSparse(SparseVector v, double factor) {
        int index;
        if (this.indices.length == 0) {
            return;
        }
        if (this.index2location == null) {
            this.setIndex2Location();
        }
        int vNumLocs = v.numLocations();
        for (int i = 0; i < vNumLocs && (index = v.indexAtLocation(i)) <= this.maxIndex; ++i) {
            if (!this.index2location.containsKey(index)) continue;
            int n = this.index2location.get(index);
            this.values[n] = this.values[n] + v.valueAtLocation(i) * factor;
        }
    }

    @Override
    public final void plusEqualsSparse(SparseVector v) {
        int index;
        if (this.indices.length == 0) {
            return;
        }
        if (this.index2location == null) {
            this.setIndex2Location();
        }
        for (int i = 0; i < v.numLocations() && (index = v.indexAtLocation(i)) <= this.maxIndex; ++i) {
            int location = this.index2location.get(index);
            if (!this.index2location.contains(index)) continue;
            int n = location;
            this.values[n] = this.values[n] + v.valueAtLocation(i);
        }
    }

    @Override
    public final void setAll(double v) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = v;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.maxIndex);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object obj;
        int version = in.readInt();
        this.maxIndex = in.readInt();
        if (version == 0 && (obj = in.readObject()) != null && !(obj instanceof TIntIntHashMap)) {
            throw new IOException("Unexpected object in de-serialization: " + obj);
        }
    }
}

