/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.OutputStream;

class CompoundFileReader
extends Directory {
    private Directory directory;
    private String fileName;
    private boolean open;
    private InputStream stream;
    private HashMap entries = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundFileReader(Directory dir2, String name) throws IOException {
        this.directory = dir2;
        this.fileName = name;
        boolean success = false;
        try {
            this.stream = dir2.openFile(name);
            int count = this.stream.readVInt();
            FileEntry entry = null;
            for (int i = 0; i < count; ++i) {
                long offset = this.stream.readLong();
                String id = this.stream.readString();
                if (entry != null) {
                    entry.length = offset - entry.offset;
                }
                entry = new FileEntry();
                entry.offset = offset;
                this.entries.put(id, entry);
            }
            if (entry != null) {
                entry.length = this.stream.length() - entry.offset;
            }
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.fileName;
    }

    public synchronized void close() throws IOException {
        if (this.stream == null) {
            throw new IOException("Already closed");
        }
        this.entries.clear();
        this.stream.close();
        this.stream = null;
    }

    public synchronized InputStream openFile(String id) throws IOException {
        if (this.stream == null) {
            throw new IOException("Stream closed");
        }
        FileEntry entry = (FileEntry)this.entries.get(id);
        if (entry == null) {
            throw new IOException("No sub-file with id " + id + " found");
        }
        return new CSInputStream(this.stream, entry.offset, entry.length);
    }

    public String[] list() {
        String[] res = new String[this.entries.size()];
        return this.entries.keySet().toArray(res);
    }

    public boolean fileExists(String name) {
        return this.entries.containsKey(name);
    }

    public long fileModified(String name) throws IOException {
        return this.directory.fileModified(this.fileName);
    }

    public void touchFile(String name) throws IOException {
        this.directory.touchFile(this.fileName);
    }

    public void deleteFile(String name) {
        throw new UnsupportedOperationException();
    }

    public void renameFile(String from, String to) {
        throw new UnsupportedOperationException();
    }

    public long fileLength(String name) throws IOException {
        FileEntry e = (FileEntry)this.entries.get(name);
        if (e == null) {
            throw new IOException("File " + name + " does not exist");
        }
        return e.length;
    }

    public OutputStream createFile(String name) {
        throw new UnsupportedOperationException();
    }

    public Lock makeLock(String name) {
        throw new UnsupportedOperationException();
    }

    static final class CSInputStream
    extends InputStream {
        InputStream base;
        long fileOffset;

        CSInputStream(InputStream base, long fileOffset, long length) throws IOException {
            this.base = base;
            this.fileOffset = fileOffset;
            this.length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            InputStream inputStream = this.base;
            synchronized (inputStream) {
                long start = this.getFilePointer();
                if (start + (long)len > this.length) {
                    throw new IOException("read past EOF");
                }
                this.base.seek(this.fileOffset + start);
                this.base.readBytes(b, offset, len);
            }
        }

        protected void seekInternal(long pos) throws IOException {
        }

        public void close() throws IOException {
        }
    }

    private static final class FileEntry {
        long offset;
        long length;

        private FileEntry() {
        }
    }
}

