/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;

public abstract class IndexReader {
    private final Directory directory;
    private final boolean directoryOwner;
    private final SegmentInfos segmentInfos;
    private Lock writeLock;
    private boolean stale;
    private boolean hasChanges;
    private final boolean closeDirectory;

    protected IndexReader(Directory directory) {
        this.directory = directory;
        this.segmentInfos = null;
        this.directoryOwner = false;
        this.closeDirectory = false;
        this.stale = false;
        this.hasChanges = false;
        this.writeLock = null;
    }

    IndexReader(Directory directory, SegmentInfos segmentInfos, boolean closeDirectory) {
        this.directory = directory;
        this.segmentInfos = segmentInfos;
        this.directoryOwner = true;
        this.closeDirectory = closeDirectory;
        this.stale = false;
        this.hasChanges = false;
        this.writeLock = null;
    }

    public static IndexReader open(String path) throws IOException {
        return IndexReader.open(FSDirectory.getDirectory(path, false), true);
    }

    public static IndexReader open(File path) throws IOException {
        return IndexReader.open(FSDirectory.getDirectory(path, false), true);
    }

    public static IndexReader open(Directory directory) throws IOException {
        return IndexReader.open(directory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexReader open(final Directory directory, final boolean closeDirectory) throws IOException {
        Directory directory2 = directory;
        synchronized (directory2) {
            return (IndexReader)new Lock.With(directory.makeLock("commit.lock"), IndexWriter.COMMIT_LOCK_TIMEOUT){

                public Object doBody() throws IOException {
                    SegmentInfos infos = new SegmentInfos();
                    infos.read(directory);
                    if (infos.size() == 1) {
                        return new SegmentReader(infos, infos.info(0), closeDirectory);
                    }
                    IndexReader[] readers = new IndexReader[infos.size()];
                    for (int i = 0; i < infos.size(); ++i) {
                        readers[i] = new SegmentReader(infos.info(i));
                    }
                    return new MultiReader(directory, infos, closeDirectory, readers);
                }
            }.run();
        }
    }

    public Directory directory() {
        return this.directory;
    }

    public static long lastModified(String directory) throws IOException {
        return IndexReader.lastModified(new File(directory));
    }

    public static long lastModified(File directory) throws IOException {
        return FSDirectory.fileModified(directory, "segments");
    }

    public static long lastModified(Directory directory) throws IOException {
        return directory.fileModified("segments");
    }

    public static long getCurrentVersion(String directory) throws IOException {
        return IndexReader.getCurrentVersion(new File(directory));
    }

    public static long getCurrentVersion(File directory) throws IOException {
        FSDirectory dir2 = FSDirectory.getDirectory(directory, false);
        long version = IndexReader.getCurrentVersion(dir2);
        ((Directory)dir2).close();
        return version;
    }

    public static long getCurrentVersion(Directory directory) throws IOException {
        return SegmentInfos.readCurrentVersion(directory);
    }

    public abstract TermFreqVector[] getTermFreqVectors(int var1) throws IOException;

    public abstract TermFreqVector getTermFreqVector(int var1, String var2) throws IOException;

    public static boolean indexExists(String directory) {
        return new File(directory, "segments").exists();
    }

    public static boolean indexExists(File directory) {
        return new File(directory, "segments").exists();
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return directory.fileExists("segments");
    }

    public abstract int numDocs();

    public abstract int maxDoc();

    public abstract Document document(int var1) throws IOException;

    public abstract boolean isDeleted(int var1);

    public abstract boolean hasDeletions();

    public abstract byte[] norms(String var1) throws IOException;

    public abstract void norms(String var1, byte[] var2, int var3) throws IOException;

    public final synchronized void setNorm(int doc, String field, byte value) throws IOException {
        if (this.directoryOwner) {
            this.aquireWriteLock();
        }
        this.doSetNorm(doc, field, value);
        this.hasChanges = true;
    }

    protected abstract void doSetNorm(int var1, String var2, byte var3) throws IOException;

    public void setNorm(int doc, String field, float value) throws IOException {
        this.setNorm(doc, field, Similarity.encodeNorm(value));
    }

    public abstract TermEnum terms() throws IOException;

    public abstract TermEnum terms(Term var1) throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public TermDocs termDocs(Term term) throws IOException {
        TermDocs termDocs = this.termDocs();
        termDocs.seek(term);
        return termDocs;
    }

    public abstract TermDocs termDocs() throws IOException;

    public TermPositions termPositions(Term term) throws IOException {
        TermPositions termPositions = this.termPositions();
        termPositions.seek(term);
        return termPositions;
    }

    public abstract TermPositions termPositions() throws IOException;

    private void aquireWriteLock() throws IOException {
        if (this.stale) {
            throw new IOException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
        }
        if (this.writeLock == null) {
            Lock writeLock = this.directory.makeLock("write.lock");
            if (!writeLock.obtain(IndexWriter.WRITE_LOCK_TIMEOUT)) {
                throw new IOException("Index locked for write: " + writeLock);
            }
            this.writeLock = writeLock;
            if (SegmentInfos.readCurrentVersion(this.directory) > this.segmentInfos.getVersion()) {
                this.stale = true;
                this.writeLock.release();
                this.writeLock = null;
                throw new IOException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
            }
        }
    }

    public final synchronized void delete(int docNum) throws IOException {
        if (this.directoryOwner) {
            this.aquireWriteLock();
        }
        this.doDelete(docNum);
        this.hasChanges = true;
    }

    protected abstract void doDelete(int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int delete(Term term) throws IOException {
        TermDocs docs = this.termDocs(term);
        if (docs == null) {
            return 0;
        }
        int n = 0;
        try {
            while (docs.next()) {
                this.delete(docs.doc());
                ++n;
            }
        }
        finally {
            docs.close();
        }
        return n;
    }

    public final synchronized void undeleteAll() throws IOException {
        if (this.directoryOwner) {
            this.aquireWriteLock();
        }
        this.doUndeleteAll();
        this.hasChanges = true;
    }

    protected abstract void doUndeleteAll() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void commit() throws IOException {
        if (this.hasChanges) {
            if (this.directoryOwner) {
                Directory directory = this.directory;
                synchronized (directory) {
                    new Lock.With(this.directory.makeLock("commit.lock"), IndexWriter.COMMIT_LOCK_TIMEOUT){

                        public Object doBody() throws IOException {
                            IndexReader.this.doCommit();
                            IndexReader.this.segmentInfos.write(IndexReader.this.directory);
                            return null;
                        }
                    }.run();
                }
                if (this.writeLock != null) {
                    this.writeLock.release();
                    this.writeLock = null;
                }
            } else {
                this.doCommit();
            }
        }
        this.hasChanges = false;
    }

    protected abstract void doCommit() throws IOException;

    public final synchronized void close() throws IOException {
        this.commit();
        this.doClose();
        if (this.closeDirectory) {
            this.directory.close();
        }
    }

    protected abstract void doClose() throws IOException;

    protected final void finalize() throws IOException {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    public abstract Collection getFieldNames() throws IOException;

    public abstract Collection getFieldNames(boolean var1) throws IOException;

    public abstract Collection getIndexedFieldNames(boolean var1);

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.makeLock("write.lock").isLocked() || directory.makeLock("commit.lock").isLocked();
    }

    public static boolean isLocked(String directory) throws IOException {
        FSDirectory dir2 = FSDirectory.getDirectory(directory, false);
        boolean result = IndexReader.isLocked(dir2);
        ((Directory)dir2).close();
        return result;
    }

    public static void unlock(Directory directory) throws IOException {
        directory.makeLock("write.lock").release();
        directory.makeLock("commit.lock").release();
    }
}

