/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.imp;
import org.python.util.CommandLineOptions;
import org.python.util.InteractiveConsole;

public class jython {
    private static String usage = "usage: jython [options] [-jar jar | -c cmd | file | -] [args]\nOptions and arguments:\n-i       : inspect interactively after running script, and force\n           prompts, even if stdin does not appear to be a terminal\n-S       : don't imply `import site' on initialization\n-v       : verbose (trace import statements)\n-Dprop=v : Set the property `prop' to value `v'\n-jar jar : program read from __run__.py in jar file\n-c cmd   : program passed in as string (terminates option list)\n-W arg   : warning control (arg is action:message:category:module:lineno)\n-E codec : Use a different codec the reading from the console.\n-Q arg   : division options: -Qold (default), -Qwarn, -Qwarnall, -Qnew\nfile     : program read from script file\n-        : program read from stdin (default; interactive mode if a tty)\n--help   : print this usage message and exit\n--version: print Jython version number and exit\nargs     : arguments passed to program in sys.argv[1:]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runJar(String filename) {
        try {
            PyCode code;
            ZipFile zip = new ZipFile(filename);
            ZipEntry runit = zip.getEntry("__run__.py");
            if (runit == null) {
                throw Py.ValueError("jar file missing '__run__.py'");
            }
            PyStringMap locals = new PyStringMap();
            locals.__setitem__("__name__", (PyObject)new PyString(filename));
            locals.__setitem__("zipfile", Py.java2py(zip));
            InputStream file = zip.getInputStream(runit);
            try {
                code = Py.compile(file, "__run__", "exec");
            }
            finally {
                file.close();
            }
            Py.runCode(code, locals, locals);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        InteractiveConsole interp;
        CommandLineOptions opts;
        block43: {
            block44: {
                block45: {
                    block42: {
                        opts = new CommandLineOptions();
                        if (!opts.parse(args)) {
                            if (opts.version) {
                                System.err.println(InteractiveConsole.getDefaultBanner());
                                System.exit(0);
                            }
                            System.err.println(usage);
                            int exitcode = opts.help ? 0 : -1;
                            System.exit(exitcode);
                        }
                        PySystemState.initialize(System.getProperties(), opts.properties, opts.argv);
                        if (opts.notice) {
                            System.err.println(InteractiveConsole.getDefaultBanner());
                        }
                        interp = null;
                        try {
                            String interpClass = PySystemState.registry.getProperty("python.console", "org.python.util.InteractiveConsole");
                            interp = (InteractiveConsole)Class.forName(interpClass).newInstance();
                        }
                        catch (Exception e) {
                            interp = new InteractiveConsole();
                        }
                        PyModule mod = imp.addModule("__main__");
                        interp.setLocals(mod.__dict__);
                        for (int i = 0; i < opts.warnoptions.size(); ++i) {
                            String wopt = (String)opts.warnoptions.elementAt(i);
                            PySystemState.warnoptions.append(new PyString(wopt));
                        }
                        String msg = "";
                        if (Options.importSite) {
                            try {
                                boolean license;
                                imp.load("site");
                                if (!opts.notice) break block42;
                                PyObject builtins = Py.getSystemState().builtins;
                                boolean copyright = builtins.__finditem__("copyright") != null;
                                boolean credits = builtins.__finditem__("credits") != null;
                                boolean bl = license = builtins.__finditem__("license") != null;
                                if (copyright) {
                                    msg = msg + "\"copyright\"";
                                    if (credits && license) {
                                        msg = msg + ", ";
                                    } else if (credits || license) {
                                        msg = msg + " or ";
                                    }
                                }
                                if (credits) {
                                    msg = msg + "\"credits\"";
                                    if (license) {
                                        msg = msg + " or ";
                                    }
                                }
                                if (license) {
                                    msg = msg + "\"license\"";
                                }
                                if (msg.length() > 0) {
                                    System.err.println("Type " + msg + " for more information.");
                                }
                            }
                            catch (PyException pye) {
                                if (Py.matchException(pye, Py.ImportError)) break block42;
                                System.err.println("error importing site");
                                Py.printException(pye);
                                System.exit(-1);
                            }
                        }
                    }
                    if (opts.division != null) {
                        if ("old".equals(opts.division)) {
                            Options.divisionWarning = 0;
                        } else if ("warn".equals(opts.division)) {
                            Options.divisionWarning = 1;
                        } else if ("warnall".equals(opts.division)) {
                            Options.divisionWarning = 2;
                        } else if ("new".equals(opts.division)) {
                            Options.Qnew = true;
                            interp.cflags.division = true;
                        }
                    }
                    if (opts.command != null) {
                        try {
                            interp.exec(opts.command);
                        }
                        catch (Throwable t) {
                            Py.printException(t);
                        }
                    }
                    if (opts.filename == null) break block44;
                    String path = new File(opts.filename).getParent();
                    if (path == null) {
                        path = "";
                    }
                    Py.getSystemState().path.insert(0, new PyString(path));
                    if (!opts.jar) break block45;
                    jython.runJar(opts.filename);
                    break block43;
                }
                if (opts.filename.equals("-")) {
                    try {
                        interp.execfile(System.in, "<stdin>");
                    }
                    catch (Throwable t) {
                        Py.printException(t);
                    }
                    break block43;
                } else {
                    try {
                        interp.execfile(opts.filename);
                    }
                    catch (Throwable t) {
                        Py.printException(t);
                        if (!opts.interactive) {
                            interp.cleanup();
                            System.exit(-1);
                        }
                        break block43;
                    }
                }
            }
            Py.getSystemState().path.insert(0, new PyString(""));
        }
        if (opts.interactive) {
            if (opts.encoding == null) {
                opts.encoding = PySystemState.registry.getProperty("python.console.encoding", null);
            }
            if (opts.encoding != null) {
                interp.cflags.encoding = opts.encoding;
            }
            try {
                interp.interact(null);
            }
            catch (Throwable t) {
                Py.printException(t);
            }
        }
        interp.cleanup();
        if (opts.interactive) {
            System.exit(0);
        }
    }
}

