/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.estimators.Estimator;

public class BayesNetGenerator
extends BayesNet {
    int m_nSeed = 1;
    Random random;
    boolean m_bGenerateNet = false;
    int m_nNrOfNodes = 10;
    int m_nNrOfArcs = 10;
    int m_nNrOfInstances = 10;
    int m_nCardinality = 2;
    String m_sBIFFile = "";

    public void generateRandomNetwork() throws Exception {
        if (this.m_otherBayesNet == null) {
            this.Init(this.m_nNrOfNodes, this.m_nCardinality);
            this.generateRandomNetworkStructure(this.m_nNrOfNodes, this.m_nNrOfArcs);
            this.generateRandomDistributions(this.m_nNrOfNodes, this.m_nCardinality);
        } else {
            this.m_nNrOfNodes = this.m_otherBayesNet.getNrOfNodes();
            this.m_ParentSets = this.m_otherBayesNet.getParentSets();
            this.m_Distributions = this.m_otherBayesNet.getDistributions();
            this.random = new Random(this.m_nSeed);
            FastVector fastVector = new FastVector(this.m_nNrOfNodes);
            for (int i = 0; i < this.m_nNrOfNodes; ++i) {
                int n = this.m_otherBayesNet.getCardinality(i);
                FastVector fastVector2 = new FastVector(n + 1);
                for (int j = 0; j < n; ++j) {
                    fastVector2.addElement(this.m_otherBayesNet.getNodeValue(i, j));
                }
                Attribute attribute = new Attribute(this.m_otherBayesNet.getNodeName(i), fastVector2);
                fastVector.addElement(attribute);
            }
            this.m_Instances = new Instances(this.m_otherBayesNet.getName(), fastVector, 100);
            this.m_Instances.setClassIndex(this.m_nNrOfNodes - 1);
        }
    }

    public void Init(int n, int n2) throws Exception {
        int n3;
        this.random = new Random(this.m_nSeed);
        FastVector fastVector = new FastVector(n);
        FastVector fastVector2 = new FastVector(n2 + 1);
        for (n3 = 0; n3 < n2; ++n3) {
            fastVector2.addElement("Value" + (n3 + 1));
        }
        for (n3 = 0; n3 < n; ++n3) {
            Attribute attribute = new Attribute("Node" + (n3 + 1), fastVector2);
            fastVector.addElement(attribute);
        }
        this.m_Instances = new Instances("RandomNet", fastVector, 100);
        this.m_Instances.setClassIndex(n - 1);
        this.setUseADTree(false);
        this.initStructure();
        this.m_Distributions = new Estimator[n][1];
        for (n3 = 0; n3 < n; ++n3) {
            this.m_Distributions[n3][0] = new DiscreteEstimatorBayes(n2, this.getEstimator().getAlpha());
        }
    }

    public void generateRandomNetworkStructure(int n, int n2) throws Exception {
        if (n2 < n - 1) {
            throw new Exception("Number of arcs should be at least (nNodes - 1) = " + (n - 1) + " instead of " + n2);
        }
        if (n2 > n * (n - 1) / 2) {
            throw new Exception("Number of arcs should be at most nNodes * (nNodes - 1) / 2 = " + n * (n - 1) / 2 + " instead of " + n2);
        }
        if (n2 == 0) {
            return;
        }
        this.generateTree(n);
        for (int i = n - 1; i < n2; ++i) {
            boolean bl = false;
            while (!bl) {
                int n3;
                int n4 = this.random.nextInt(n);
                if (n4 == (n3 = this.random.nextInt(n))) {
                    n3 = (n4 + 1) % n;
                }
                if (n3 < n4) {
                    int n5 = n4;
                    n4 = n3;
                    n3 = n5;
                }
                if (this.m_ParentSets[n3].contains(n4)) continue;
                this.m_ParentSets[n3].addParent(n4, this.m_Instances);
                bl = true;
            }
        }
    }

    void generateTree(int n) {
        int n2;
        int n3;
        boolean[] blArray = new boolean[n];
        int n4 = this.random.nextInt(n);
        if (n4 == (n3 = this.random.nextInt(n))) {
            n3 = (n4 + 1) % n;
        }
        if (n3 < n4) {
            n2 = n4;
            n4 = n3;
            n3 = n2;
        }
        this.m_ParentSets[n3].addParent(n4, this.m_Instances);
        blArray[n4] = true;
        blArray[n3] = true;
        for (n2 = 2; n2 < n; ++n2) {
            int n5;
            n4 = 0;
            for (n5 = this.random.nextInt(n); n5 >= 0; --n5) {
                n4 = (n4 + 1) % n;
                while (!blArray[n4]) {
                    n4 = (n4 + 1) % n;
                }
            }
            n3 = 0;
            for (n5 = this.random.nextInt(n); n5 >= 0; --n5) {
                n3 = (n3 + 1) % n;
                while (blArray[n3]) {
                    n3 = (n3 + 1) % n;
                }
            }
            if (n3 < n4) {
                int n6 = n4;
                n4 = n3;
                n3 = n6;
            }
            this.m_ParentSets[n3].addParent(n4, this.m_Instances);
            blArray[n4] = true;
            blArray[n3] = true;
        }
    }

    void generateRandomDistributions(int n, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = 0; n3 < n; ++n3) {
            if (this.m_ParentSets[n3].getCardinalityOfParents() <= n4) continue;
            n4 = this.m_ParentSets[n3].getCardinalityOfParents();
        }
        this.m_Distributions = new Estimator[this.m_Instances.numAttributes()][n4];
        for (n3 = 0; n3 < n; ++n3) {
            int[] nArray = new int[n2 + 1];
            nArray[0] = 0;
            nArray[n2] = 1000;
            for (int i = 0; i < this.m_ParentSets[n3].getCardinalityOfParents(); ++i) {
                int n5;
                int n6;
                for (n6 = 1; n6 < n2; ++n6) {
                    nArray[n6] = this.random.nextInt(1000);
                }
                for (n6 = 1; n6 < n2; ++n6) {
                    for (n5 = n6 + 1; n5 < n2; ++n5) {
                        if (nArray[n5] >= nArray[n6]) continue;
                        int n7 = nArray[n5];
                        nArray[n5] = nArray[n6];
                        nArray[n6] = n7;
                    }
                }
                DiscreteEstimatorBayes discreteEstimatorBayes = new DiscreteEstimatorBayes(n2, this.getEstimator().getAlpha());
                for (n5 = 0; n5 < n2; ++n5) {
                    discreteEstimatorBayes.addValue(n5, nArray[n5 + 1] - nArray[n5]);
                }
                this.m_Distributions[n3][i] = discreteEstimatorBayes;
            }
        }
    }

    public void generateInstances() {
        for (int i = 0; i < this.m_nNrOfInstances; ++i) {
            int n = this.m_Instances.numAttributes();
            Instance instance = new Instance(n);
            instance.setDataset(this.m_Instances);
            for (int j = 0; j < n; ++j) {
                double d = 0.0;
                for (int k = 0; k < this.m_ParentSets[j].getNrOfParents(); ++k) {
                    int n2 = this.m_ParentSets[j].getParent(k);
                    d = d * (double)this.m_Instances.attribute(n2).numValues() + instance.value(n2);
                }
                double d2 = (float)this.random.nextInt(1000) / 1000.0f;
                int n3 = 0;
                while (d2 > this.m_Distributions[j][(int)d].getProbability(n3)) {
                    d2 -= this.m_Distributions[j][(int)d].getProbability(n3);
                    ++n3;
                }
                instance.setValue(j, (double)n3);
            }
            this.m_Instances.add(instance);
        }
    }

    public String toString() {
        if (this.m_bGenerateNet) {
            return this.toXMLBIF03();
        }
        StringBuffer stringBuffer = new StringBuffer();
        return this.m_Instances.toString();
    }

    void setNrOfNodes(int n) {
        this.m_nNrOfNodes = n;
    }

    void setNrOfArcs(int n) {
        this.m_nNrOfArcs = n;
    }

    void setNrOfInstances(int n) {
        this.m_nNrOfInstances = n;
    }

    void setCardinality(int n) {
        this.m_nCardinality = n;
    }

    void setSeed(int n) {
        this.m_nSeed = n;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option("\tGenerate network (instead of instances)\n", "B", 0, "-B"));
        vector.addElement(new Option("\tNr of nodes\n", "N", 1, "-N <integer>"));
        vector.addElement(new Option("\tNr of arcs\n", "A", 1, "-A <integer>"));
        vector.addElement(new Option("\tNr of instances\n", "M", 1, "-M <integer>"));
        vector.addElement(new Option("\tCardinality of the variables\n", "C", 1, "-C <integer>"));
        vector.addElement(new Option("\tSeed for random number generator\n", "S", 1, "-S <integer>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.m_bGenerateNet = Utils.getFlag('B', stringArray);
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNrOfNodes(Integer.parseInt(string));
        } else {
            this.setNrOfNodes(10);
        }
        String string2 = Utils.getOption('A', stringArray);
        if (string2.length() != 0) {
            this.setNrOfArcs(Integer.parseInt(string2));
        } else {
            this.setNrOfArcs(10);
        }
        String string3 = Utils.getOption('M', stringArray);
        if (string3.length() != 0) {
            this.setNrOfInstances(Integer.parseInt(string3));
        } else {
            this.setNrOfInstances(10);
        }
        String string4 = Utils.getOption('C', stringArray);
        if (string4.length() != 0) {
            this.setCardinality(Integer.parseInt(string4));
        } else {
            this.setCardinality(2);
        }
        String string5 = Utils.getOption('S', stringArray);
        if (string5.length() != 0) {
            this.setSeed(Integer.parseInt(string5));
        } else {
            this.setSeed(1);
        }
        String string6 = Utils.getOption('F', stringArray);
        if (string6 != null && string6 != "") {
            this.setBIFFile(string6);
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[13];
        int n = 0;
        if (this.m_bGenerateNet) {
            stringArray[n++] = "-B";
        }
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_nNrOfNodes;
        stringArray[n++] = "-A";
        stringArray[n++] = "" + this.m_nNrOfArcs;
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.m_nNrOfInstances;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.m_nCardinality;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.m_nSeed;
        if (this.m_sBIFFile.length() != 0) {
            stringArray[n++] = "-F";
            stringArray[n++] = "" + this.m_sBIFFile;
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    protected static void printOptions(OptionHandler optionHandler) {
        Enumeration enumeration = optionHandler.listOptions();
        System.out.println("Options for " + optionHandler.getClass().getName() + ":\n");
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            System.out.println(option.synopsis());
            System.out.println(option.description());
        }
    }

    public static void main(String[] stringArray) {
        BayesNetGenerator bayesNetGenerator = new BayesNetGenerator();
        try {
            if (stringArray.length == 0 || Utils.getFlag('h', stringArray)) {
                BayesNetGenerator.printOptions(bayesNetGenerator);
                return;
            }
            bayesNetGenerator.setOptions(stringArray);
            bayesNetGenerator.generateRandomNetwork();
            if (!bayesNetGenerator.m_bGenerateNet) {
                bayesNetGenerator.generateInstances();
            }
            System.out.println(bayesNetGenerator.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BayesNetGenerator.printOptions(bayesNetGenerator);
        }
    }
}

