/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.CharMatchScore;
import com.wcohen.secondstring.MemoMatrix;
import com.wcohen.secondstring.StringWrapper;

public class NeedlemanWunsch
extends AbstractStringDistance {
    private CharMatchScore charMatchScore;
    private double gapCost;

    public NeedlemanWunsch() {
        this(CharMatchScore.DIST_01, 1.0);
    }

    public NeedlemanWunsch(CharMatchScore charMatchScore, double gapCost) {
        this.charMatchScore = charMatchScore;
        this.gapCost = gapCost;
    }

    public double score(StringWrapper s, StringWrapper t) {
        MyMatrix mat = new MyMatrix(s, t);
        return mat.get(s.length(), t.length());
    }

    public String explainScore(StringWrapper s, StringWrapper t) {
        MyMatrix mat = new MyMatrix(s, t);
        double d = mat.get(s.length(), t.length());
        mat.setPrintNegativeValues(true);
        return mat.toString() + "\nScore = " + d;
    }

    public static void main(String[] argv) {
        NeedlemanWunsch.doMain(new NeedlemanWunsch(), argv);
    }

    private class MyMatrix
    extends MemoMatrix {
        public MyMatrix(StringWrapper s, StringWrapper t) {
            super(s, t);
        }

        public double compute(int i, int j) {
            if (i == 0) {
                return (double)(-j) * NeedlemanWunsch.this.gapCost;
            }
            if (j == 0) {
                return (double)(-i) * NeedlemanWunsch.this.gapCost;
            }
            return MyMatrix.max3(this.get(i - 1, j - 1) + NeedlemanWunsch.this.charMatchScore.matchScore(this.sAt(i), this.tAt(j)), this.get(i - 1, j) - NeedlemanWunsch.this.gapCost, this.get(i, j - 1) - NeedlemanWunsch.this.gapCost);
        }
    }
}

