/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring.expt;

import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.StringWrapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class MatchData {
    private Map sourceLists;
    private ArrayList sourceNames;
    private String filename;

    public MatchData(String filename) throws InputFormatException {
        this.filename = filename;
        this.sourceNames = new ArrayList();
        this.sourceLists = new HashMap();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            int lineNum = 0;
            while ((line = in.readLine()) != null) {
                ++lineNum;
                StringTokenizer tok = new StringTokenizer(line, "\t");
                if (!tok.hasMoreTokens()) {
                    throw new InputFormatException(filename, lineNum, "no source");
                }
                String src = tok.nextToken();
                if (!tok.hasMoreTokens()) {
                    throw new InputFormatException(filename, lineNum, "no id");
                }
                String id = tok.nextToken();
                if (!tok.hasMoreTokens()) {
                    throw new InputFormatException(filename, lineNum, "no text fields");
                }
                String text = tok.nextToken();
                this.addInstance(src, id, text);
            }
            in.close();
        }
        catch (IOException e) {
            throw new InputFormatException(filename, 0, e.toString());
        }
    }

    public MatchData() {
        this.filename = "none";
        this.sourceNames = new ArrayList();
        this.sourceLists = new HashMap();
    }

    public void addInstance(String src, String id, String text) {
        Instance inst = new Instance(src, id, text);
        ArrayList<Instance> list = (ArrayList<Instance>)this.sourceLists.get(src);
        if (list == null) {
            list = new ArrayList<Instance>();
            this.sourceLists.put(src, list);
            this.sourceNames.add(src);
        }
        list.add(inst);
    }

    public int numSources() {
        return this.sourceNames.size();
    }

    public String getSource(int i) {
        return (String)this.sourceNames.get(i);
    }

    public int numInstances(String src) {
        return ((ArrayList)this.sourceLists.get(src)).size();
    }

    public Instance getInstance(String src, int j) {
        return (Instance)((ArrayList)this.sourceLists.get(src)).get(j);
    }

    public void prepare(StringDistance distance) {
        distance.accumulateStatistics(new MatchIterator());
        for (int i = 0; i < this.numSources(); ++i) {
            String src = this.getSource(i);
            for (int j = 0; j < this.numInstances(src); ++j) {
                Instance inst = this.getInstance(src, j);
                inst.prepare(distance);
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.numSources(); ++i) {
            String src = this.getSource(i);
            for (int j = 0; j < this.numInstances(src); ++j) {
                Instance inst = this.getInstance(src, j);
                buf.append(inst.toString() + "\n");
            }
        }
        return buf.toString();
    }

    public static void main(String[] argv) {
        try {
            System.out.println(new MatchData(argv[0]).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class InputFormatException
    extends Exception {
        public InputFormatException(String file, int line, String msg) {
            super("line " + line + " of file " + file + ": " + msg);
        }
    }

    public class MatchIterator
    implements Iterator {
        private int sourceCursor = 0;
        private int instanceCursor = 0;
        private String src;

        public MatchIterator() {
            this.src = MatchData.this.getSource(this.sourceCursor);
        }

        public void remove() {
            throw new IllegalStateException("remove not implemented");
        }

        public String getSource() {
            return this.src;
        }

        public StringWrapper nextStringWrapper() {
            return (StringWrapper)this.next();
        }

        public boolean hasNext() {
            return this.sourceCursor < MatchData.this.numSources() && this.instanceCursor < MatchData.this.numInstances(this.src);
        }

        public Object next() {
            Instance inst = MatchData.this.getInstance(this.src, this.instanceCursor++);
            if (this.instanceCursor > MatchData.this.numInstances(this.src)) {
                ++this.sourceCursor;
                if (this.sourceCursor < MatchData.this.numSources()) {
                    this.src = MatchData.this.getSource(this.sourceCursor);
                }
            }
            return inst.getText();
        }
    }

    public static class Instance {
        private final String source;
        private final String id;
        private StringWrapper text;

        public Instance(String source, String id, String text) {
            this.source = source.trim();
            this.id = id.trim();
            this.text = new StringWrapper(text.trim());
        }

        public String getSource() {
            return this.source;
        }

        public String getId() {
            return this.id;
        }

        public StringWrapper getText() {
            return this.text;
        }

        public String toString() {
            return "[src: '" + this.source + "' id: '" + this.id + "' text: '" + this.text + "']";
        }

        public void prepare(StringDistance distance) {
            this.text = distance.prepare(this.text.unwrap());
        }
    }
}

