/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.Directory;

final class TermInfosReader {
    private Directory directory;
    private String segment;
    private FieldInfos fieldInfos;
    private ThreadLocal enumerators = new ThreadLocal();
    private SegmentTermEnum origEnum;
    private long size;
    Term[] indexTerms = null;
    TermInfo[] indexInfos;
    long[] indexPointers;

    TermInfosReader(Directory dir2, String seg, FieldInfos fis) throws IOException {
        this.directory = dir2;
        this.segment = seg;
        this.fieldInfos = fis;
        this.origEnum = new SegmentTermEnum(this.directory.openFile(this.segment + ".tis"), this.fieldInfos, false);
        this.size = this.origEnum.size;
        this.readIndex();
    }

    public int getSkipInterval() {
        return this.origEnum.skipInterval;
    }

    final void close() throws IOException {
        if (this.origEnum != null) {
            this.origEnum.close();
        }
    }

    final long size() {
        return this.size;
    }

    private SegmentTermEnum getEnum() {
        SegmentTermEnum termEnum = (SegmentTermEnum)this.enumerators.get();
        if (termEnum == null) {
            termEnum = this.terms();
            this.enumerators.set(termEnum);
        }
        return termEnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readIndex() throws IOException {
        SegmentTermEnum indexEnum = new SegmentTermEnum(this.directory.openFile(this.segment + ".tii"), this.fieldInfos, true);
        try {
            int indexSize = (int)indexEnum.size;
            this.indexTerms = new Term[indexSize];
            this.indexInfos = new TermInfo[indexSize];
            this.indexPointers = new long[indexSize];
            int i = 0;
            while (indexEnum.next()) {
                this.indexTerms[i] = indexEnum.term();
                this.indexInfos[i] = indexEnum.termInfo();
                this.indexPointers[i] = indexEnum.indexPointer;
                ++i;
            }
        }
        finally {
            indexEnum.close();
        }
    }

    private final int getIndexOffset(Term term) throws IOException {
        int lo = 0;
        int hi = this.indexTerms.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int delta = term.compareTo(this.indexTerms[mid]);
            if (delta < 0) {
                hi = mid - 1;
                continue;
            }
            if (delta > 0) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        return hi;
    }

    private final void seekEnum(int indexOffset) throws IOException {
        this.getEnum().seek(this.indexPointers[indexOffset], indexOffset * this.getEnum().indexInterval - 1, this.indexTerms[indexOffset], this.indexInfos[indexOffset]);
    }

    TermInfo get(Term term) throws IOException {
        int enumOffset;
        if (this.size == 0L) {
            return null;
        }
        SegmentTermEnum enumerator = this.getEnum();
        if (enumerator.term() != null && (enumerator.prev != null && term.compareTo(enumerator.prev) > 0 || term.compareTo(enumerator.term()) >= 0) && (this.indexTerms.length == (enumOffset = (int)(enumerator.position / (long)enumerator.indexInterval) + 1) || term.compareTo(this.indexTerms[enumOffset]) < 0)) {
            return this.scanEnum(term);
        }
        this.seekEnum(this.getIndexOffset(term));
        return this.scanEnum(term);
    }

    private final TermInfo scanEnum(Term term) throws IOException {
        SegmentTermEnum enumerator = this.getEnum();
        while (term.compareTo(enumerator.term()) > 0 && enumerator.next()) {
        }
        if (enumerator.term() != null && term.compareTo(enumerator.term()) == 0) {
            return enumerator.termInfo();
        }
        return null;
    }

    final Term get(int position) throws IOException {
        if (this.size == 0L) {
            return null;
        }
        SegmentTermEnum enumerator = this.getEnum();
        if (enumerator != null && enumerator.term() != null && (long)position >= enumerator.position && (long)position < enumerator.position + (long)enumerator.indexInterval) {
            return this.scanEnum(position);
        }
        this.seekEnum(position / enumerator.indexInterval);
        return this.scanEnum(position);
    }

    private final Term scanEnum(int position) throws IOException {
        SegmentTermEnum enumerator = this.getEnum();
        while (enumerator.position < (long)position) {
            if (enumerator.next()) continue;
            return null;
        }
        return enumerator.term();
    }

    final long getPosition(Term term) throws IOException {
        if (this.size == 0L) {
            return -1L;
        }
        int indexOffset = this.getIndexOffset(term);
        this.seekEnum(indexOffset);
        SegmentTermEnum enumerator = this.getEnum();
        while (term.compareTo(enumerator.term()) > 0 && enumerator.next()) {
        }
        if (term.compareTo(enumerator.term()) == 0) {
            return enumerator.position;
        }
        return -1L;
    }

    public SegmentTermEnum terms() {
        return (SegmentTermEnum)this.origEnum.clone();
    }

    public SegmentTermEnum terms(Term term) throws IOException {
        this.get(term);
        return (SegmentTermEnum)this.getEnum().clone();
    }
}

