/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleProcedure;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class TDoubleArrayList
implements Serializable,
Cloneable {
    protected double[] _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;

    public TDoubleArrayList() {
        this(10);
    }

    public TDoubleArrayList(int capacity) {
        this._data = new double[capacity];
        this._pos = 0;
    }

    public TDoubleArrayList(double[] values) {
        this(Math.max(values.length, 10));
        this.add(values);
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            double[] tmp = new double[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            double[] tmp = new double[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    public void add(double val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public void add(double[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(double[] vals, int offset, int length) {
        this.ensureCapacity(this._pos + length);
        System.arraycopy(vals, offset, this._data, this._pos, length);
        this._pos += length;
    }

    public void insert(int offset, double value) {
        if (offset == this._pos) {
            this.add(value);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset, this._data, offset + 1, this._pos - offset);
        this._data[offset] = value;
        ++this._pos;
    }

    public void insert(int offset, double[] values) {
        this.insert(offset, values, 0, values.length);
    }

    public void insert(int offset, double[] values, int valOffset, int len) {
        if (offset == this._pos) {
            this.add(values, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset, this._data, offset + len, this._pos - offset);
        System.arraycopy(values, valOffset, this._data, offset, len);
        this._pos += len;
    }

    public double get(int offset) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data[offset];
    }

    public double getQuick(int offset) {
        return this._data[offset];
    }

    public void set(int offset, double val) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data[offset] = val;
    }

    public double getSet(int offset, double val) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        double old = this._data[offset];
        this._data[offset] = val;
        return old;
    }

    public void set(int offset, double[] values) {
        this.set(offset, values, 0, values.length);
    }

    public void set(int offset, double[] values, int valOffset, int length) {
        if (offset < 0 || offset + length >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(values, valOffset, this._data, offset, length);
    }

    public void setQuick(int offset, double val) {
        this._data[offset] = val;
    }

    public void clear() {
        this.clear(10);
    }

    public void clear(int capacity) {
        this._data = new double[capacity];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        this.fill(0.0);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public double remove(int offset) {
        double old = this.get(offset);
        this.remove(offset, 1);
        return old;
    }

    public void remove(int offset, int length) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset) {
            System.arraycopy(this._data, offset + length, this._data, offset, this._pos - (offset + length));
        }
        this._pos -= length;
    }

    public void transformValues(TDoubleFunction function) {
        int i = this._pos;
        while (i-- > 0) {
            this._data[i] = function.execute(this._data[i]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i = from;
        int j = to - 1;
        while (i < j) {
            this.swap(i, j);
            ++i;
            --j;
        }
    }

    public void shuffle(Random rand) {
        int i = this._pos;
        while (i-- > 1) {
            this.swap(i, rand.nextInt(i));
        }
    }

    private final void swap(int i, int j) {
        double tmp = this._data[i];
        this._data[i] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {}
        return o;
    }

    public double[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public double[] toNativeArray(int offset, int len) {
        double[] rv = new double[len];
        this.toNativeArray(rv, offset, len);
        return rv;
    }

    public void toNativeArray(double[] dest, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, 0, dest, offset, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TDoubleArrayList) {
            TDoubleArrayList that = (TDoubleArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data[i] == that._data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data[i]);
        }
        return h;
    }

    public boolean forEach(TDoubleProcedure procedure) {
        int i = 0;
        while (i < this._pos) {
            if (!procedure.execute(this._data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean forEachDescending(TDoubleProcedure procedure) {
        int i = this._pos;
        while (i-- > 0) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    public void sort(int fromIndex, int toIndex) {
        Arrays.sort(this._data, fromIndex, toIndex);
    }

    public void fill(double val) {
        Arrays.fill(this._data, 0, this._pos, val);
    }

    public void fill(int fromIndex, int toIndex, double val) {
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        Arrays.fill(this._data, fromIndex, toIndex, val);
    }

    public int binarySearch(double value) {
        return this.binarySearch(value, 0, this._pos);
    }

    public int binarySearch(double value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            double midVal = this._data[mid];
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(double value) {
        return this.indexOf(0, value);
    }

    public int indexOf(int offset, double value) {
        int i = offset;
        while (i < this._pos) {
            if (this._data[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(double value) {
        return this.lastIndexOf(this._pos, value);
    }

    public int lastIndexOf(int offset, double value) {
        int i = offset;
        while (i-- > 0) {
            if (this._data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(double value) {
        return this.lastIndexOf(value) >= 0;
    }

    public TDoubleArrayList grep(TDoubleProcedure condition) {
        TDoubleArrayList list = new TDoubleArrayList();
        int i = 0;
        while (i < this._pos) {
            if (condition.execute(this._data[i])) {
                list.add(this._data[i]);
            }
            ++i;
        }
        return list;
    }

    public TDoubleArrayList inverseGrep(TDoubleProcedure condition) {
        TDoubleArrayList list = new TDoubleArrayList();
        int i = 0;
        while (i < this._pos) {
            if (!condition.execute(this._data[i])) {
                list.add(this._data[i]);
            }
            ++i;
        }
        return list;
    }

    public double max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        double max = this._data[this._pos - 1];
        int i = this._pos - 1;
        while (i-- > 0) {
            if (!(this._data[i] > max)) continue;
            max = this._data[i];
        }
        return max;
    }

    public double min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        double min = this._data[this._pos - 1];
        int i = this._pos - 1;
        while (i-- > 0) {
            if (!(this._data[i] < min)) continue;
            min = this._data[i];
        }
        return min;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        int i = 0;
        int end = this._pos - 1;
        while (i < end) {
            buf.append(this._data[i]);
            buf.append(", ");
            ++i;
        }
        if (this.size() > 0) {
            buf.append(this._data[this._pos - 1]);
        }
        buf.append("}");
        return buf.toString();
    }
}

