package edu.umass.cs.mallet.base.util.search;

/**
 * Created by IntelliJ IDEA.
 * User: pereira
 * Date: Jun 19, 2005
 * Time: 1:07:17 PM
 * Search node in an A* search.
 */
public class AStarNode extends SearchNode {
  /**
   * Iterator over new A* search nodes generated by state transitions
   * from this node's state.
   */
  public class NextNodeIterator extends SearchNode.NextNodeIterator {
    protected NextNodeIterator() {
      super();
    }
    public SearchNode nextNode() {
      AStarNode p = AStarNode.this;
      AStarState s = (AStarState)getStateIter().nextState();
      return new AStarNode(s, p, p.getCost() + cost());
    }
  }
  /**
   * Create an A* search node with given state, parent, and cost.
   * @param state the state
   * @param parent the parent
   * @param cost the cost
   */
  public AStarNode(AStarState state, AStarNode parent, double cost) {
    super(state, parent, cost); }
  /**
   * Get the completion cost for the underlying state.
   * @return the completion cost
   */
  public double completionCost() {
    return ((AStarState)getState()).completionCost();
  }
  public SearchNode.NextNodeIterator getNextNodes() {
    return new NextNodeIterator();
  }

}
