/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.Posting;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.OutputStream;

final class DocumentWriter {
    private Analyzer analyzer;
    private Directory directory;
    private Similarity similarity;
    private FieldInfos fieldInfos;
    private int maxFieldLength;
    private final Hashtable postingTable = new Hashtable();
    private int[] fieldLengths;
    private float[] fieldBoosts;
    private final Term termBuffer = new Term("", "");

    DocumentWriter(Directory directory, Analyzer analyzer, Similarity similarity, int maxFieldLength) {
        this.directory = directory;
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.maxFieldLength = maxFieldLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addDocument(String segment, Document doc) throws IOException {
        this.fieldInfos = new FieldInfos();
        this.fieldInfos.add(doc);
        this.fieldInfos.write(this.directory, segment + ".fnm");
        FieldsWriter fieldsWriter = new FieldsWriter(this.directory, segment, this.fieldInfos);
        try {
            fieldsWriter.addDocument(doc);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fieldsWriter.close();
            throw throwable;
        }
        fieldsWriter.close();
        this.postingTable.clear();
        this.fieldLengths = new int[this.fieldInfos.size()];
        this.fieldBoosts = new float[this.fieldInfos.size()];
        Arrays.fill(this.fieldBoosts, doc.getBoost());
        this.invertDocument(doc);
        Posting[] postings = this.sortPostingTable();
        this.writePostings(postings, segment);
        this.writeNorms(doc, segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void invertDocument(Document doc) throws IOException {
        Enumeration fields = doc.fields();
        while (fields.hasMoreElements()) {
            Field field = (Field)fields.nextElement();
            String fieldName = field.name();
            int fieldNumber = this.fieldInfos.fieldNumber(fieldName);
            int position = this.fieldLengths[fieldNumber];
            if (!field.isIndexed()) continue;
            if (!field.isTokenized()) {
                this.addPosition(fieldName, field.stringValue(), position++);
            } else {
                Object var11_10;
                Reader reader;
                if (field.readerValue() != null) {
                    reader = field.readerValue();
                } else if (field.stringValue() != null) {
                    reader = new StringReader(field.stringValue());
                } else {
                    throw new IllegalArgumentException("field must have either String or Reader value");
                }
                TokenStream stream = this.analyzer.tokenStream(fieldName, reader);
                try {
                    Token t = stream.next();
                    while (t != null) {
                        position += t.getPositionIncrement() - 1;
                        this.addPosition(fieldName, t.termText(), position++);
                        if (position > this.maxFieldLength) break;
                        t = stream.next();
                    }
                    var11_10 = null;
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    stream.close();
                    throw throwable;
                }
                stream.close();
                {
                }
            }
            this.fieldLengths[fieldNumber] = position;
            int n = fieldNumber;
            this.fieldBoosts[n] = this.fieldBoosts[n] * field.getBoost();
        }
    }

    private final void addPosition(String field, String text, int position) {
        this.termBuffer.set(field, text);
        Posting ti = (Posting)this.postingTable.get(this.termBuffer);
        if (ti != null) {
            int freq = ti.freq;
            if (ti.positions.length == freq) {
                int[] newPositions = new int[freq * 2];
                int[] positions = ti.positions;
                int i = 0;
                while (i < freq) {
                    newPositions[i] = positions[i];
                    ++i;
                }
                ti.positions = newPositions;
            }
            ti.positions[freq] = position;
            ti.freq = freq + 1;
        } else {
            Term term = new Term(field, text, false);
            this.postingTable.put(term, new Posting(term, position));
        }
    }

    private final Posting[] sortPostingTable() {
        Posting[] array = new Posting[this.postingTable.size()];
        Enumeration postings = this.postingTable.elements();
        int i = 0;
        while (postings.hasMoreElements()) {
            array[i] = (Posting)postings.nextElement();
            ++i;
        }
        DocumentWriter.quickSort(array, 0, array.length - 1);
        return array;
    }

    private static final void quickSort(Posting[] postings, int lo, int hi) {
        int right;
        int left;
        Posting tmp;
        if (lo >= hi) {
            return;
        }
        int mid = (lo + hi) / 2;
        if (postings[lo].term.compareTo(postings[mid].term) > 0) {
            tmp = postings[lo];
            postings[lo] = postings[mid];
            postings[mid] = tmp;
        }
        if (postings[mid].term.compareTo(postings[hi].term) > 0) {
            tmp = postings[mid];
            postings[mid] = postings[hi];
            postings[hi] = tmp;
            if (postings[lo].term.compareTo(postings[mid].term) > 0) {
                Posting tmp2 = postings[lo];
                postings[lo] = postings[mid];
                postings[mid] = tmp2;
            }
        }
        if ((left = lo + 1) >= (right = hi - 1)) {
            return;
        }
        Term partition = postings[mid].term;
        while (true) {
            if (postings[right].term.compareTo(partition) > 0) {
                --right;
                continue;
            }
            while (left < right && postings[left].term.compareTo(partition) <= 0) {
                ++left;
            }
            if (left >= right) break;
            Posting tmp2 = postings[left];
            postings[left] = postings[right];
            postings[right] = tmp2;
            --right;
        }
        DocumentWriter.quickSort(postings, lo, left);
        DocumentWriter.quickSort(postings, left + 1, hi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writePostings(Posting[] postings, String segment) throws IOException {
        OutputStream freq = null;
        OutputStream prox = null;
        TermInfosWriter tis = null;
        try {
            freq = this.directory.createFile(segment + ".frq");
            prox = this.directory.createFile(segment + ".prx");
            tis = new TermInfosWriter(this.directory, segment, this.fieldInfos);
            TermInfo ti = new TermInfo();
            int i = 0;
            while (i < postings.length) {
                Posting posting = postings[i];
                ti.set(1, freq.getFilePointer(), prox.getFilePointer());
                tis.add(posting.term, ti);
                int f = posting.freq;
                if (f == 1) {
                    freq.writeVInt(1);
                } else {
                    freq.writeVInt(0);
                    freq.writeVInt(f);
                }
                int lastPosition = 0;
                int[] positions = posting.positions;
                int j = 0;
                while (j < f) {
                    int position = positions[j];
                    prox.writeVInt(position - lastPosition);
                    lastPosition = position;
                    ++j;
                }
                ++i;
            }
        }
        finally {
            if (freq != null) {
                freq.close();
            }
            if (prox != null) {
                prox.close();
            }
            if (tis != null) {
                tis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeNorms(Document doc, String segment) throws IOException {
        Enumeration fields = doc.fields();
        while (fields.hasMoreElements()) {
            Object var9_8;
            Field field = (Field)fields.nextElement();
            if (!field.isIndexed()) continue;
            int n = this.fieldInfos.fieldNumber(field.name());
            float norm = this.fieldBoosts[n] * this.similarity.lengthNorm(field.name(), this.fieldLengths[n]);
            OutputStream norms = this.directory.createFile(segment + ".f" + n);
            try {
                norms.writeByte(Similarity.encodeNorm(norm));
                var9_8 = null;
            }
            catch (Throwable throwable) {
                var9_8 = null;
                norms.close();
                throw throwable;
            }
            norms.close();
            {
            }
        }
    }
}

