/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

final class BooleanScorer
extends Scorer {
    private int currentDoc;
    private SubScorer scorers = null;
    private BucketTable bucketTable = new BucketTable(this);
    private int maxCoord = 1;
    private float[] coordFactors = null;
    private int requiredMask = 0;
    private int prohibitedMask = 0;
    private int nextMask = 1;

    BooleanScorer(Similarity similarity) {
        super(similarity);
    }

    final void add(Scorer scorer, boolean required, boolean prohibited) {
        int mask = 0;
        if (required || prohibited) {
            if (this.nextMask == 0) {
                throw new IndexOutOfBoundsException("More than 32 required/prohibited clauses in query.");
            }
            mask = this.nextMask;
            this.nextMask <<= 1;
        } else {
            mask = 0;
        }
        if (!prohibited) {
            ++this.maxCoord;
        }
        if (prohibited) {
            this.prohibitedMask |= mask;
        } else if (required) {
            this.requiredMask |= mask;
        }
        this.scorers = new SubScorer(scorer, required, prohibited, this.bucketTable.newCollector(mask), this.scorers);
    }

    private final void computeCoordFactors() throws IOException {
        this.coordFactors = new float[this.maxCoord];
        int i = 0;
        while (i < this.maxCoord) {
            this.coordFactors[i] = this.getSimilarity().coord(i, this.maxCoord - 1);
            ++i;
        }
    }

    public final void score(HitCollector results, int maxDoc) throws IOException {
        if (this.coordFactors == null) {
            this.computeCoordFactors();
        }
        while (this.currentDoc < maxDoc) {
            this.currentDoc = Math.min(this.currentDoc + 1024, maxDoc);
            SubScorer t = this.scorers;
            while (t != null) {
                t.scorer.score(t.collector, this.currentDoc);
                t = t.next;
            }
            this.bucketTable.collectHits(results);
        }
    }

    public Explanation explain(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    static final class Collector
    extends HitCollector {
        private BucketTable bucketTable;
        private int mask;

        public Collector(int mask, BucketTable bucketTable) {
            this.mask = mask;
            this.bucketTable = bucketTable;
        }

        public final void collect(int doc, float score) {
            BucketTable table = this.bucketTable;
            int i = doc & 0x3FF;
            Bucket bucket = table.buckets[i];
            if (bucket == null) {
                table.buckets[i] = bucket = new Bucket();
            }
            if (bucket.doc != doc) {
                bucket.doc = doc;
                bucket.score = score;
                bucket.bits = this.mask;
                bucket.coord = 1;
                bucket.next = table.first;
                table.first = bucket;
            } else {
                bucket.score += score;
                bucket.bits |= this.mask;
                ++bucket.coord;
            }
        }
    }

    static final class BucketTable {
        public static final int SIZE = 1024;
        public static final int MASK = 1023;
        final Bucket[] buckets = new Bucket[1024];
        Bucket first = null;
        private BooleanScorer scorer;

        public BucketTable(BooleanScorer scorer) {
            this.scorer = scorer;
        }

        public final void collectHits(HitCollector results) {
            int required = this.scorer.requiredMask;
            int prohibited = this.scorer.prohibitedMask;
            float[] coord = this.scorer.coordFactors;
            Bucket bucket = this.first;
            while (bucket != null) {
                if ((bucket.bits & prohibited) == 0 && (bucket.bits & required) == required) {
                    results.collect(bucket.doc, bucket.score * coord[bucket.coord]);
                }
                bucket = bucket.next;
            }
            this.first = null;
        }

        public final int size() {
            return 1024;
        }

        public HitCollector newCollector(int mask) {
            return new Collector(mask, this);
        }
    }

    static final class Bucket {
        int doc = -1;
        float score;
        int bits;
        int coord;
        Bucket next;

        Bucket() {
        }
    }

    static final class SubScorer {
        public Scorer scorer;
        public boolean required = false;
        public boolean prohibited = false;
        public HitCollector collector;
        public SubScorer next;

        public SubScorer(Scorer scorer, boolean required, boolean prohibited, HitCollector collector, SubScorer next) {
            this.scorer = scorer;
            this.required = required;
            this.prohibited = prohibited;
            this.collector = collector;
            this.next = next;
        }
    }
}

